/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

public class DataSourceType {
    private static final int _COUNTER = 0;
    private static final String STR_COUNTER = "COUNTER";
    public static final DataSourceType COUNTER = new DataSourceType(0);
    private static final int _ABSOLUTE = 1;
    private static final String STR_ABSOLUTE = "ABSOLUTE";
    public static final DataSourceType ABSOLUTE = new DataSourceType(1);
    private static final int _GAUGE = 2;
    private static final String STR_GAUGE = "GAUGE";
    public static final DataSourceType GAUGE = new DataSourceType(2);
    private static final int _DERIVE = 3;
    private static final String STR_DERIVE = "DERIVE";
    public static final DataSourceType DERIVE = new DataSourceType(3);
    private int type;

    private DataSourceType(int n) {
        this.type = n;
    }

    public static DataSourceType get(String string) {
        if (string.equalsIgnoreCase(STR_COUNTER)) {
            return COUNTER;
        }
        if (string.equalsIgnoreCase(STR_ABSOLUTE)) {
            return ABSOLUTE;
        }
        if (string.equalsIgnoreCase(STR_GAUGE)) {
            return GAUGE;
        }
        if (string.equalsIgnoreCase(STR_DERIVE)) {
            return DERIVE;
        }
        throw new IllegalArgumentException("Invalid DataSourceType");
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataSourceType)) {
            throw new IllegalArgumentException("Not a DataSourceType");
        }
        return ((DataSourceType)object).type == this.type;
    }

    public String toString() {
        String string;
        switch (this.type) {
            case 0: {
                string = STR_COUNTER;
                break;
            }
            case 1: {
                string = STR_ABSOLUTE;
                break;
            }
            case 2: {
                string = STR_GAUGE;
                break;
            }
            case 3: {
                string = STR_DERIVE;
                break;
            }
            default: {
                throw new RuntimeException("This should never happen");
            }
        }
        return string;
    }
}

