/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class JDBCTask
extends Task {
    private static Hashtable loaderMap = new Hashtable(3);
    private boolean caching;
    private Path classpath;
    private AntClassLoader loader;
    private boolean autocommit;
    private String driver;
    private String url;
    private String userId;
    private String password;
    private String rdbms;
    private String version;

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    public void setCaching(boolean bl) {
        this.caching = bl;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setAutocommit(boolean bl) {
        this.autocommit = bl;
    }

    public void setRdbms(String string) {
        this.rdbms = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    protected boolean isValidRdbms(Connection connection) {
        if (this.rdbms == null && this.version == null) {
            return true;
        }
        try {
            String string;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (this.rdbms != null) {
                string = databaseMetaData.getDatabaseProductName().toLowerCase();
                this.log("RDBMS = " + string, 3);
                if (string == null || string.indexOf(this.rdbms) < 0) {
                    this.log("Not the required RDBMS: " + this.rdbms, 3);
                    return false;
                }
            }
            if (this.version != null) {
                string = databaseMetaData.getDatabaseProductVersion().toLowerCase();
                this.log("Version = " + string, 3);
                if (string == null || !string.startsWith(this.version) && string.indexOf(" " + this.version) < 0) {
                    this.log("Not the required version: \"" + this.version + '\"', 3);
                    return false;
                }
            }
        }
        catch (SQLException sQLException) {
            this.log("Failed to obtain required RDBMS information", 0);
            return false;
        }
        return true;
    }

    protected static Hashtable getLoaderMap() {
        return loaderMap;
    }

    protected AntClassLoader getLoader() {
        return this.loader;
    }

    protected Connection getConnection() throws BuildException {
        if (this.userId == null) {
            throw new BuildException("User Id attribute must be set!", this.getLocation());
        }
        if (this.password == null) {
            throw new BuildException("Password attribute must be set!", this.getLocation());
        }
        if (this.url == null) {
            throw new BuildException("Url attribute must be set!", this.getLocation());
        }
        try {
            this.log("connecting to " + this.getUrl(), 3);
            Properties properties = new Properties();
            properties.put("user", this.getUserId());
            properties.put("password", this.getPassword());
            Connection connection = this.getDriver().connect(this.getUrl(), properties);
            if (connection == null) {
                throw new SQLException("No suitable Driver for " + this.url);
            }
            connection.setAutoCommit(this.autocommit);
            return connection;
        }
        catch (SQLException sQLException) {
            throw new BuildException(sQLException, this.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Driver getDriver() throws BuildException {
        if (this.driver == null) {
            throw new BuildException("Driver attribute must be set!", this.getLocation());
        }
        Driver driver = null;
        try {
            Class<?> clazz;
            if (this.classpath != null) {
                block12: {
                    Hashtable hashtable = loaderMap;
                    synchronized (hashtable) {
                        block11: {
                            if (this.caching) {
                                this.loader = (AntClassLoader)loaderMap.get(this.driver);
                            }
                            if (this.loader != null) break block11;
                            this.log("Loading " + this.driver + " using AntClassLoader with classpath " + this.classpath, 3);
                            this.loader = this.getProject().createClassLoader(this.classpath);
                            if (this.caching) {
                                loaderMap.put(this.driver, this.loader);
                            }
                            break block12;
                        }
                        this.log("Loading " + this.driver + " using a cached AntClassLoader.", 3);
                    }
                }
                clazz = this.loader.loadClass(this.driver);
                return (Driver)clazz.newInstance();
            }
            this.log("Loading " + this.driver + " using system loader.", 3);
            clazz = Class.forName(this.driver);
            return (Driver)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("Class Not Found: JDBC driver " + this.driver + " could not be loaded", this.getLocation());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException("Illegal Access: JDBC driver " + this.driver + " could not be loaded", this.getLocation());
        }
        catch (InstantiationException instantiationException) {
            throw new BuildException("Instantiation Exception: JDBC driver " + this.driver + " could not be loaded", this.getLocation());
        }
    }

    public void isCaching(boolean bl) {
        this.caching = bl;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserid(String string) {
        this.userId = string;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRdbms() {
        return this.rdbms;
    }

    public String getVersion() {
        return this.version;
    }

    private final /* synthetic */ void this() {
        this.caching = true;
        this.autocommit = false;
        this.driver = null;
        this.url = null;
        this.userId = null;
        this.password = null;
        this.rdbms = null;
        this.version = null;
    }

    public JDBCTask() {
        this.this();
    }
}

