/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.popup;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.popup.PopupCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class PopupMsg
extends PopupCommand {
    private static final int TYPE_MSG = 1;
    private static final int TYPE_URL = 2;
    private static final int TYPE_WIDTH = 3;
    private static final int TYPE_HEIGHT = 4;
    private static final int TYPE_DELAY = 5;
    private final String message;
    private final String url;
    private final int width;
    private final int height;
    private final int delay;

    protected PopupMsg(SnacPacket snacPacket) {
        super(2);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        this.message = immutableTlvChain.getString(1);
        this.url = immutableTlvChain.getString(2);
        this.width = immutableTlvChain.getUShort(3);
        this.height = immutableTlvChain.getUShort(4);
        this.delay = immutableTlvChain.getUShort(5);
    }

    public PopupMsg(String string, String string2, int n, int n2, int n3) {
        super(2);
        this.message = string;
        this.url = string2;
        this.width = n;
        this.height = n2;
        this.delay = n3;
    }

    public final String getMessage() {
        return this.message;
    }

    public final String getUrl() {
        return this.url;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getDelay() {
        return this.delay;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.message != null) {
            Tlv.getStringInstance(1, this.message).write(outputStream);
        }
        if (this.url != null) {
            Tlv.getStringInstance(2, this.url).write(outputStream);
        }
        if (this.width != -1) {
            Tlv.getUShortInstance(3, this.width).write(outputStream);
        }
        if (this.height != -1) {
            Tlv.getUShortInstance(4, this.height).write(outputStream);
        }
        if (this.delay != -1) {
            Tlv.getUShortInstance(5, this.delay).write(outputStream);
        }
    }

    public String toString() {
        return "PopupMsg (" + this.width + " x " + this.height + ", delay=" + this.delay + "): " + this.message + " (" + this.url + ")";
    }
}

