/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;
import net.kano.joscar.snaccmd.icbm.ParamInfo;

public class ParamInfoCmd
extends IcbmCommand {
    private final ParamInfo paramInfo;

    protected ParamInfoCmd(SnacPacket snacPacket) {
        super(5);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.paramInfo = ParamInfo.readParamInfo(byteBlock);
    }

    public ParamInfoCmd(ParamInfo paramInfo) {
        super(5);
        this.paramInfo = paramInfo;
    }

    public final ParamInfo getParamInfo() {
        return this.paramInfo;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.paramInfo != null) {
            this.paramInfo.write(outputStream);
        }
    }

    public String toString() {
        return "ParamInfoCmd: paramInfo=<" + this.paramInfo + ">";
    }
}

