/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.acct.AcctModCmd;
import net.kano.joscar.snaccmd.auth.AuthCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class AuthResponse
extends AuthCommand {
    public static final int ERROR_INVALID_SN_OR_PASS_A = 1;
    public static final int ERROR_INVALID_SN_OR_PASS_B = 4;
    public static final int ERROR_BAD_PASSWORD = 5;
    public static final int ERROR_BAD_INPUT = 6;
    public static final int ERROR_ACCOUNT_DELETED = 8;
    public static final int ERROR_SIGNON_BLOCKED = 17;
    public static final int ERROR_TEMP_UNAVAILABLE_A = 12;
    public static final int ERROR_TEMP_UNAVAILABLE_B = 13;
    public static final int ERROR_TEMP_UNAVAILABLE_C = 19;
    public static final int ERROR_TEMP_UNAVAILABLE_D = 20;
    public static final int ERROR_TEMP_UNAVAILABLE_E = 21;
    public static final int ERROR_TEMP_UNAVAILABLE_F = 26;
    public static final int ERROR_TEMP_UNAVAILABLE_G = 31;
    public static final int ERROR_CONNECTING_TOO_MUCH_A = 24;
    public static final int ERROR_CONNECTING_TOO_MUCH_B = 28;
    public static final int ERROR_CLIENT_TOO_OLD = 27;
    public static final int ERROR_SOMETHING_FUNNY = 28;
    public static final int ERROR_INVALID_SECURID = 32;
    public static final int ERROR_UNDER_13 = 34;
    private static final int TYPE_SN = 1;
    private static final int TYPE_SERVER = 5;
    private static final int TYPE_COOKIE = 6;
    private static final int TYPE_EMAIL = 17;
    private static final int TYPE_ERRCODE = 8;
    private static final int TYPE_ERRURL = 4;
    private static final int TYPE_REGSTATUS = 19;
    private final String sn;
    private final String server;
    private final int port;
    private final ByteBlock cookie;
    private final int regstatus;
    private final String email;
    private final int errorCode;
    private final String errorUrl;

    protected AuthResponse(SnacPacket snacPacket) {
        super(3);
        DefensiveTools.checkNull(snacPacket, "packet");
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(snacPacket.getData());
        this.sn = immutableTlvChain.getString(1);
        String string = immutableTlvChain.getString(5);
        String string2 = null;
        int n = -1;
        if (string != null && string.indexOf(58) != -1) {
            string = string.trim();
            int n2 = string.indexOf(58);
            String string3 = string.substring(n2 + 1);
            try {
                n = Integer.parseInt(string3);
                string2 = string.substring(0, n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.server = string2;
        this.port = n;
        this.cookie = immutableTlvChain.hasTlv(6) ? immutableTlvChain.getLastTlv(6).getData() : null;
        this.email = immutableTlvChain.getString(17);
        this.regstatus = immutableTlvChain.getUShort(19);
        this.errorCode = immutableTlvChain.getUShort(8);
        this.errorUrl = immutableTlvChain.getString(4);
    }

    public AuthResponse(String string, String string2, int n, ByteBlock byteBlock, int n2, String string3) {
        this(string, string2, n, byteBlock, n2, string3, -1, null);
    }

    public AuthResponse(int n, String string) {
        this(null, null, -1, null, -1, null, n, string);
    }

    public AuthResponse(String string, String string2, int n, ByteBlock byteBlock, int n2, String string3, int n3, String string4) {
        super(3);
        DefensiveTools.checkRange(n, "port", -1);
        DefensiveTools.checkRange(n2, "regStatus", -1);
        DefensiveTools.checkRange(n3, "errorCode", -1);
        this.sn = string;
        this.server = string2;
        this.port = n;
        this.cookie = byteBlock;
        this.regstatus = n2;
        this.email = string3;
        this.errorCode = n3;
        this.errorUrl = string4;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final String getServer() {
        return this.server;
    }

    public final int getPort() {
        return this.port;
    }

    public final ByteBlock getCookie() {
        return this.cookie;
    }

    public final int getRegstatus() {
        return this.regstatus;
    }

    public final String getEmail() {
        return this.email;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorUrl() {
        return this.errorUrl;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.sn != null) {
            Tlv.getStringInstance(1, this.sn).write(outputStream);
        }
        if (this.server != null) {
            String string = this.server;
            if (this.port != -1) {
                string = string + ":" + this.port;
            }
            Tlv.getStringInstance(5, string).write(outputStream);
        }
        if (this.cookie != null) {
            new Tlv(6, this.cookie).write(outputStream);
        }
        if (this.errorCode != -1) {
            Tlv.getUShortInstance(8, this.errorCode).write(outputStream);
        }
        if (this.errorUrl != null) {
            Tlv.getStringInstance(4, this.errorUrl).write(outputStream);
        }
        if (this.email != null) {
            Tlv.getStringInstance(17, this.email).write(outputStream);
        }
        if (this.regstatus != -1) {
            Tlv.getUShortInstance(19, this.regstatus).write(outputStream);
        }
    }

    public String toString() {
        String string = null;
        if (this.errorCode != -1) {
            string = MiscTools.findIntField(AuthResponse.class, this.errorCode, "ERROR_.*");
        }
        String string2 = null;
        if (this.regstatus != -1) {
            string2 = MiscTools.findIntField(AcctModCmd.class, this.regstatus, "REGSTATUS_.*");
        }
        return "AuthResponse: sn='" + this.sn + "'" + ", server='" + this.server + "'" + ", port=" + this.port + (this.regstatus == -1 ? "" : ", regStatus=0x" + Integer.toHexString(this.regstatus) + " (" + (string2 == null ? "unknown status code" : string2) + ")") + ", email='" + this.email + "'" + (this.errorCode == -1 ? "" : ", errorCode=0x" + Integer.toHexString(this.errorCode) + " (" + (string == null ? "unknown error code" : string) + ")") + (this.errorUrl == null ? "" : ", errorURL='" + this.errorUrl + "'");
    }
}

