/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.OscarTools;

public class MiniUserInfo
implements LiveWritable {
    private final String sn;
    private final int warningLevel;
    private final int totalSize;

    public static MiniUserInfo readUserInfo(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() == 0) {
            return null;
        }
        short s = BinaryTools.getUByte(byteBlock, 0);
        if (byteBlock.getLength() < s + 1) {
            return null;
        }
        String string = BinaryTools.getAsciiString(byteBlock.subBlock(1, s));
        int n = 1 + s;
        int n2 = -1;
        if (byteBlock.getLength() >= 1 + s + 2) {
            n2 = BinaryTools.getUShort(byteBlock, 1 + s + 2);
            n += 2;
        }
        return new MiniUserInfo(string, n2, n);
    }

    protected MiniUserInfo(String string, int n, int n2) {
        DefensiveTools.checkNull(string, "sn");
        DefensiveTools.checkRange(n, "warningLevel", 0);
        DefensiveTools.checkRange(n2, "totalSize", -1);
        this.sn = string;
        this.warningLevel = n;
        this.totalSize = n2;
    }

    public MiniUserInfo(String string, int n) {
        this(string, n, -1);
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final int getWarningLevel() {
        return this.warningLevel;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream outputStream) throws IOException {
        OscarTools.writeScreenname(outputStream, this.sn);
        BinaryTools.writeUShort(outputStream, this.warningLevel);
    }

    public String toString() {
        return "MiniUserInfo: " + this.sn + " (" + this.warningLevel + "%)";
    }
}

