/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.snaccmd.AbstractChatInfo;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public final class ExchangeInfo
extends AbstractChatInfo
implements LiveWritable {
    private static final int TYPE_URL = 212;
    private final int number;
    private final String url;

    public static ExchangeInfo readExchangeInfo(ByteBlock byteBlock) {
        if (byteBlock.getLength() < 2) {
            return null;
        }
        return new ExchangeInfo(byteBlock);
    }

    ExchangeInfo(ByteBlock byteBlock) {
        this.number = BinaryTools.getUShort(byteBlock, 0);
        ByteBlock byteBlock2 = byteBlock.subBlock(2);
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock2);
        this.readBaseInfo(immutableTlvChain);
        this.url = immutableTlvChain.getString(212);
    }

    public final int getNumber() {
        return this.number;
    }

    public final String getUrl() {
        return this.url;
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.number);
        this.writeBaseInfo(outputStream);
        if (this.url != null) {
            Tlv.getStringInstance(212, this.url).write(outputStream);
        }
    }

    public String toString() {
        return "ExchangeInfo for #" + this.number + ", url='" + this.url + "'" + " - " + super.toString();
    }
}

