/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;

public final class CapabilityBlock
implements Writable {
    public static final CapabilityBlock BLOCK_CHAT = new CapabilityBlock(new byte[]{116, -113, 36, 32, 98, -121, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
    public static final CapabilityBlock BLOCK_VOICE = new CapabilityBlock(new byte[]{9, 70, 19, 65, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
    public static final CapabilityBlock BLOCK_FILE_SEND = new CapabilityBlock(new byte[]{9, 70, 19, 67, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
    public static final CapabilityBlock BLOCK_DIRECTIM = new CapabilityBlock(new byte[]{9, 70, 19, 69, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
    public static final CapabilityBlock BLOCK_ICON = new CapabilityBlock(new byte[]{9, 70, 19, 70, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
    public static final CapabilityBlock BLOCK_FILE_GET = new CapabilityBlock(new byte[]{9, 70, 19, 72, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
    public static final CapabilityBlock BLOCK_GAMES = new CapabilityBlock(new byte[]{9, 70, 19, 74, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
    public static final CapabilityBlock BLOCK_GAMES2 = new CapabilityBlock(new byte[]{9, 70, 19, 74, 76, 127, 17, -47, 34, -126, 68, 69, 83, 84, 0, 0});
    public static final CapabilityBlock BLOCK_SENDBUDDYLIST = new CapabilityBlock(new byte[]{9, 70, 19, 75, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
    public static final CapabilityBlock BLOCK_TRILLIANCRYPT = new CapabilityBlock(new byte[]{-14, -25, -57, -12, -2, -83, 77, -5, -78, 53, 54, 121, -117, -33, 0, 0});
    public static final CapabilityBlock BLOCK_ICQCOMPATIBLE = new CapabilityBlock(new byte[]{9, 70, 19, 77, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
    public static final CapabilityBlock BLOCK_ADDINS = new CapabilityBlock(new byte[]{9, 70, 19, 71, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
    public static final CapabilityBlock BLOCK_SOMETHING = new CapabilityBlock(new byte[]{9, 70, 1, -1, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
    public static final CapabilityBlock BLOCK_SHORTCAPS = new CapabilityBlock(new byte[]{9, 70, 0, 0, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
    public static final CapabilityBlock BLOCK_ENCRYPTION = new CapabilityBlock(new byte[]{9, 70, 0, 1, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
    private final ByteBlock block;
    private final int hashCode;

    public static byte[] convertToBytes(CapabilityBlock[] capabilityBlockArray) {
        byte[] byArray = new byte[capabilityBlockArray.length * 16];
        for (int i = 0; i < capabilityBlockArray.length; ++i) {
            capabilityBlockArray[i].getBlock().copyTo(byArray, i * 16);
        }
        return byArray;
    }

    public static CapabilityBlock[] getCapabilityBlocks(ByteBlock byteBlock) {
        CapabilityBlock[] capabilityBlockArray = new CapabilityBlock[byteBlock.getLength() / 16];
        for (int i = 0; i < capabilityBlockArray.length; ++i) {
            capabilityBlockArray[i] = new CapabilityBlock(byteBlock.subBlock(0, 16));
            byteBlock = byteBlock.subBlock(16);
        }
        return capabilityBlockArray;
    }

    private CapabilityBlock(byte[] byArray) {
        this(ByteBlock.wrap(byArray));
    }

    public CapabilityBlock(ByteBlock byteBlock) throws IllegalArgumentException {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 16) {
            throw new IllegalArgumentException("invalid capability block: length must be 16 (is " + byteBlock.getLength() + ")");
        }
        this.block = ByteBlock.wrap(byteBlock.subBlock(0, 16).toByteArray());
        long l = BinaryTools.getLong(byteBlock, 0) ^ BinaryTools.getLong(byteBlock, 8);
        this.hashCode = (int)(l >> 16 ^ l & 0xFFL);
    }

    public final ByteBlock getBlock() {
        return this.block;
    }

    public final long getWritableLength() {
        return 16L;
    }

    public void write(OutputStream outputStream) throws IOException {
        this.block.write(outputStream);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CapabilityBlock)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.block.equals(((CapabilityBlock)object).block);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        String string = "unknown capability block";
        Field[] fieldArray = CapabilityBlock.class.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("BLOCK_")) continue;
            try {
                if (!field.get(null).equals(this)) continue;
                string = field.getName();
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return "CapabilityBlock: " + BinaryTools.describeData(this.block) + " (" + string + ")";
    }
}

