/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import ymsg.network.YahooUser;

public class YahooChatUser {
    private YahooUser user;
    private int age;
    private int attributes;
    private String alias;
    private String location;
    private static final int MALE_ATTR = 32768;
    private static final int FEMALE_ATTR = 65536;
    private static final int WEBCAM_ATTR = 16;

    YahooChatUser(YahooUser yu, int at, String al, int ag, String loc) {
        this.user = yu;
        this.attributes = at;
        this.age = ag;
        this.alias = al;
        this.location = loc;
    }

    YahooChatUser(YahooUser yu, String at, String al, String ag, String loc) {
        this.user = yu;
        this.update(at, al, ag, loc);
    }

    void update(String at, String al, String ag, String loc) {
        int b;
        int a;
        try {
            a = Integer.parseInt(at);
        }
        catch (NumberFormatException e) {
            a = 0;
        }
        try {
            b = Integer.parseInt(ag);
        }
        catch (NumberFormatException e) {
            b = 0;
        }
        this.attributes = a;
        this.age = b;
        this.alias = al;
        this.location = loc;
    }

    public YahooUser getUser() {
        return this.user;
    }

    public String getId() {
        return this.user.getId();
    }

    public int getAge() {
        return this.age;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getLocation() {
        return this.location;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public boolean isMale() {
        return (this.attributes & 0x8000) > 0;
    }

    public boolean isFemale() {
        return (this.attributes & 0x10000) > 0;
    }

    public boolean hasWebcam() {
        return (this.attributes & 0x10) > 0;
    }

    public String toString() {
        return "user=[" + this.user + "] age=" + this.age + " attributes=" + Integer.toHexString(this.attributes) + " alias=" + this.alias + " location=" + this.location;
    }
}

