/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import ymsg.network.ConnectionHandler;
import ymsg.network.DebugInputStream;
import ymsg.network.DebugOutputStream;
import ymsg.network.NetworkConstants;
import ymsg.network.PacketBodyBuffer;
import ymsg.network.Session;
import ymsg.network.Util;
import ymsg.network.YMSG9InputStream;
import ymsg.network.YMSG9Packet;

public class DirectConnectionHandler
extends ConnectionHandler
implements NetworkConstants {
    private String host;
    private int port;
    private boolean dontUseFallbacks = false;
    private Socket socket;
    private YMSG9InputStream ips;
    private DataOutputStream ops;

    public DirectConnectionHandler(String h, int p) {
        this.host = h;
        this.port = p;
        this.dontUseFallbacks = true;
    }

    public DirectConnectionHandler(int p) {
        this(Util.directHost(), p);
    }

    public DirectConnectionHandler(boolean fl) {
        this();
        this.dontUseFallbacks = fl;
    }

    public DirectConnectionHandler() {
        this(Util.directHost(), Util.directPort());
        this.dontUseFallbacks = false;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    void install(Session ss, ThreadGroup tg) {
    }

    void open() throws SocketException, IOException {
        if (this.dontUseFallbacks) {
            this.socket = new Socket(this.host, this.port);
        } else {
            int[] fallbackPorts = Util.directPorts();
            int i = 0;
            while (this.socket == null) {
                try {
                    this.socket = new Socket(this.host, fallbackPorts[i]);
                    this.port = fallbackPorts[i];
                }
                catch (SocketException e) {
                    this.socket = null;
                    if (++i < fallbackPorts.length) continue;
                    throw e;
                }
            }
        }
        if (Util.debugMode) {
            this.ips = new YMSG9InputStream(new DebugInputStream(this.socket.getInputStream()));
            this.ops = new DataOutputStream(new DebugOutputStream(this.socket.getOutputStream()));
        } else {
            this.ips = new YMSG9InputStream(this.socket.getInputStream());
            this.ops = new DataOutputStream(this.socket.getOutputStream());
        }
    }

    void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPacket(PacketBodyBuffer body, int service, long status, long sessionId) throws IOException {
        byte[] b = body.getBuffer();
        DataOutputStream dataOutputStream = this.ops;
        synchronized (dataOutputStream) {
            this.ops.write(NetworkConstants.MAGIC, 0, 4);
            this.ops.write(NetworkConstants.VERSION, 0, 4);
            this.ops.writeShort(b.length & 0xFFFF);
            this.ops.writeShort(service & 0xFFFF);
            this.ops.writeInt((int)(status & 0xFFFFFFFFFFFFFFFFL));
            this.ops.writeInt((int)(sessionId & 0xFFFFFFFFFFFFFFFFL));
            this.ops.write(b, 0, b.length);
            this.ops.flush();
        }
    }

    protected YMSG9Packet receivePacket() throws IOException {
        return this.ips.readPacket();
    }

    public String toString() {
        return "Direct connection: " + this.host + ":" + this.port;
    }
}

