/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtls;

import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DefaultTlsServer;
import org.bouncycastle.crypto.tls.DefaultTlsSignerCredentials;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsSRTPUtils;
import org.bouncycastle.crypto.tls.TlsServerContext;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.UseSRTPData;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsPacketTransformer;
import org.jitsi.util.Logger;

public class TlsServerImpl
extends DefaultTlsServer {
    private static final Logger logger = Logger.getLogger(TlsServerImpl.class);
    private final CertificateRequest certificateRequest = new CertificateRequest(new short[]{1}, null);
    private int chosenProtectionProfile;
    private final DtlsPacketTransformer packetTransformer;
    private TlsSignerCredentials rsaSignerCredentials;

    public TlsServerImpl(DtlsPacketTransformer packetTransformer) {
        this.packetTransformer = packetTransformer;
    }

    public CertificateRequest getCertificateRequest() {
        return this.certificateRequest;
    }

    int getChosenProtectionProfile() {
        return this.chosenProtectionProfile;
    }

    TlsContext getContext() {
        return this.context;
    }

    private DtlsControlImpl getDtlsControl() {
        return this.packetTransformer.getDtlsControl();
    }

    protected ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.DTLSv10;
    }

    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.DTLSv10;
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        if (this.rsaSignerCredentials == null) {
            DtlsControlImpl dtlsControl = this.getDtlsControl();
            this.rsaSignerCredentials = new DefaultTlsSignerCredentials((TlsContext)this.context, dtlsControl.getCertificate(), dtlsControl.getKeyPair().getPrivate());
        }
        return this.rsaSignerCredentials;
    }

    public Hashtable getServerExtensions() throws IOException {
        Hashtable serverExtensions = super.getServerExtensions();
        if (TlsSRTPUtils.getUseSRTPExtension((Hashtable)serverExtensions) == null) {
            UseSRTPData useSRTPData;
            int chosenProtectionProfile;
            if (serverExtensions == null) {
                serverExtensions = new Hashtable();
            }
            if ((chosenProtectionProfile = DtlsControlImpl.chooseSRTPProtectionProfile((useSRTPData = TlsSRTPUtils.getUseSRTPExtension((Hashtable)this.clientExtensions)).getProtectionProfiles())) == 0) {
                String msg = "No chosen SRTP protection profile!";
                TlsFatalAlert tfa = new TlsFatalAlert(80);
                logger.error(msg, (Throwable)tfa);
                throw tfa;
            }
            TlsSRTPUtils.addUseSRTPExtension(serverExtensions, (UseSRTPData)new UseSRTPData(new int[]{chosenProtectionProfile}, useSRTPData.getMki()));
            this.chosenProtectionProfile = chosenProtectionProfile;
        }
        return serverExtensions;
    }

    public void init(TlsServerContext context) {
        super.init(context);
    }

    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        try {
            this.getDtlsControl().verifyAndValidateCertificate(clientCertificate);
        }
        catch (Exception e) {
            logger.error("Failed to verify and/or validate client certificate!", e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        UseSRTPData useSRTPData = TlsSRTPUtils.getUseSRTPExtension((Hashtable)clientExtensions);
        if (useSRTPData == null) {
            String msg = "DTLS extended client hello does not include the use_srtp extension!";
            IOException ioe = new IOException(msg);
            logger.error(msg, ioe);
            throw ioe;
        }
        int chosenProtectionProfile = DtlsControlImpl.chooseSRTPProtectionProfile(useSRTPData.getProtectionProfiles());
        if (chosenProtectionProfile == 0) {
            String msg = "No chosen SRTP protection profile!";
            TlsFatalAlert tfa = new TlsFatalAlert(47);
            logger.error(msg, (Throwable)tfa);
            throw tfa;
        }
        super.processClientExtensions(clientExtensions);
    }
}

