/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.pseudotcp.util;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Random;
import junit.framework.TestCase;
import org.ice4j.pseudotcp.util.ByteFifoBuffer;
import org.junit.Assert;

public class ByteFifoBufferTest
extends TestCase {
    public void testLength() {
        int expResult = 1000;
        ByteFifoBuffer instance = new ByteFifoBuffer(expResult);
        ByteFifoBufferTest.assertEquals((int)expResult, (int)instance.length());
        int wSize = 100;
        instance.write(this.getWData(wSize), wSize);
        int result = instance.length();
        ByteFifoBufferTest.assertEquals((int)expResult, (int)result);
    }

    public void testRead() {
        int count = 1024;
        byte[] wData = this.getWData(count);
        ByteFifoBuffer instance = new ByteFifoBuffer(count);
        instance.write(wData, count);
        byte[] readBuff = new byte[count];
        int expResult = count;
        int result = instance.read(readBuff, count);
        ByteFifoBufferTest.assertEquals((int)expResult, (int)result);
        Assert.assertArrayEquals((byte[])wData, (byte[])readBuff);
    }

    public void testReadWithOffset() {
        int count = 1024;
        byte[] wData = this.getWData(count);
        ByteFifoBuffer instance = new ByteFifoBuffer(count);
        instance.write(wData, count);
        byte[] readBuff = new byte[count];
        int expResult = count / 2;
        int result = instance.read(readBuff, count / 2);
        ByteFifoBufferTest.assertEquals((int)expResult, (int)result);
        result = instance.read(readBuff, count / 2, count / 2);
        ByteFifoBufferTest.assertEquals((int)expResult, (int)result);
        Assert.assertArrayEquals((byte[])wData, (byte[])readBuff);
    }

    private byte[] getWData(int count) {
        Random r = new Random();
        byte[] res = new byte[count];
        r.nextBytes(res);
        return res;
    }

    public void testGetWriteRemaining() {
        int len = 100;
        ByteFifoBuffer instance = new ByteFifoBuffer(len);
        int expResult = len;
        int result = instance.getWriteRemaining();
        ByteFifoBufferTest.assertEquals((int)expResult, (int)result);
        int w_size = 23;
        byte[] w_data = this.getWData(w_size);
        instance.write(w_data, w_size);
        expResult = len - w_size;
        result = instance.getWriteRemaining();
        ByteFifoBufferTest.assertEquals((int)expResult, (int)result);
    }

    public void testGetBuffered() {
        int len = 1000;
        ByteFifoBuffer instance = new ByteFifoBuffer(len);
        int w_len = 100;
        byte[] w_data = this.getWData(w_len);
        instance.write(w_data, w_len);
        int expResult = w_len;
        int result = instance.getBuffered();
        ByteFifoBufferTest.assertEquals((int)expResult, (int)result);
        int consume = 5;
        expResult = w_len + consume;
        instance.consumeWriteBuffer(consume);
        result = instance.getBuffered();
        ByteFifoBufferTest.assertEquals((int)expResult, (int)result);
    }

    public void testWrite() {
        int len = 2048;
        byte[] data = this.getWData(len);
        ByteFifoBuffer instance = new ByteFifoBuffer(len);
        int expResult = len;
        int result = instance.write(data, len);
        ByteFifoBufferTest.assertEquals((int)expResult, (int)result);
        byte[] read = new byte[len];
        int readCount = instance.read(read, len);
        ByteFifoBufferTest.assertEquals((int)result, (int)readCount);
        Assert.assertArrayEquals((byte[])data, (byte[])read);
    }

    public void testWriteWithOffset() {
        int len = 2048;
        byte[] data = this.getWData(len);
        ByteFifoBuffer instance = new ByteFifoBuffer(len);
        int expResult = len / 2;
        int result = instance.write(data, 0, len / 2);
        ByteFifoBufferTest.assertEquals((int)expResult, (int)result);
        result = instance.write(data, len / 2, len / 2);
        ByteFifoBufferTest.assertEquals((int)expResult, (int)result);
        byte[] read = new byte[len];
        int readCount = instance.read(read, len);
        ByteFifoBufferTest.assertEquals((int)len, (int)readCount);
        Assert.assertArrayEquals((byte[])data, (byte[])read);
    }

    public void testConsumeWriteBuffer() {
        int len = 100;
        ByteFifoBuffer instance = new ByteFifoBuffer(len);
        instance.consumeWriteBuffer(len / 2);
        instance.consumeWriteBuffer(len / 2);
        try {
            instance.consumeWriteBuffer(1);
            ByteFifoBufferTest.fail();
        }
        catch (BufferOverflowException bufferOverflowException) {
            // empty catch block
        }
        instance = new ByteFifoBuffer(len);
        instance.consumeWriteBuffer(95);
        instance.consumeReadData(40);
        instance.consumeWriteBuffer(20);
    }

    public void testSetCapacity() {
        int old_size = 100;
        int new_size = 200;
        ByteFifoBuffer instance = new ByteFifoBuffer(old_size);
        boolean expResult = true;
        instance.write(this.getWData(old_size), old_size);
        boolean result = instance.setCapacity(new_size);
        ByteFifoBufferTest.assertEquals((boolean)expResult, (boolean)result);
        expResult = false;
        instance.resetWritePosition();
        instance.write(this.getWData(new_size), new_size);
        result = instance.setCapacity(old_size);
        ByteFifoBufferTest.assertEquals((boolean)expResult, (boolean)result);
    }

    public void testConsumeReadData() {
        int lCount = 100;
        ByteFifoBuffer instance = new ByteFifoBuffer(lCount);
        instance.write(this.getWData(lCount), lCount);
        instance.consumeReadData(lCount / 2);
        instance.consumeReadData(lCount / 2);
        try {
            instance.consumeReadData(1);
            ByteFifoBufferTest.fail();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
    }

    public void testReadOffset() {
        int dst_buff_offset = 0;
        int len = 100;
        byte[] src_buff = this.getWData(len);
        byte[] dst_buff = new byte[len];
        int offset = 0;
        ByteFifoBuffer instance = new ByteFifoBuffer(len);
        int expResult = len;
        instance.write(src_buff, len);
        int result = instance.readOffset(dst_buff, dst_buff_offset, len, offset);
        ByteFifoBufferTest.assertEquals((int)expResult, (int)result);
        Assert.assertArrayEquals((byte[])dst_buff, (byte[])src_buff);
    }

    public void testWriteOffset() {
        int len = 200;
        int dataLen = 100;
        byte[] srcData = this.getWData(dataLen);
        byte[] data = new byte[dataLen];
        int nOffset = 10;
        ByteFifoBuffer instance = new ByteFifoBuffer(len);
        int result = instance.writeOffset(srcData, dataLen, nOffset);
        int readCount = instance.readOffset(data, 0, dataLen, nOffset);
        ByteFifoBufferTest.assertEquals((int)result, (int)readCount);
        Assert.assertArrayEquals((byte[])srcData, (byte[])data);
        byte[] halfFilled = new byte[dataLen * 2];
        System.arraycopy(srcData, 0, halfFilled, dataLen, dataLen);
        byte[] halfFilledRead = new byte[dataLen * 2];
        instance.readOffset(halfFilledRead, dataLen, dataLen, nOffset);
        Assert.assertArrayEquals((byte[])halfFilled, (byte[])halfFilledRead);
        instance = new ByteFifoBuffer(len);
        instance.write(srcData, dataLen);
        instance.write(srcData, dataLen / 2);
        instance.read(data, dataLen);
        instance.writeOffset(srcData, dataLen, 50);
        instance = new ByteFifoBuffer(61440);
        instance.writeOffset(this.getWData(1384), 1384, 31832);
    }

    public void testWriteReadWriteRead() {
        int len = 2000;
        ByteFifoBuffer instance = new ByteFifoBuffer(len);
        byte[] wrData = this.getWData(len * 2);
        int written = 0;
        byte[] readBuff = new byte[wrData.length];
        int read = 0;
        do {
            int readAvailable;
            int wrRemaining;
            if ((wrRemaining = instance.getWriteRemaining()) > 0 && written < wrData.length) {
                int wrCount = instance.writeOffset(wrData, wrRemaining, 0);
                instance.consumeWriteBuffer(wrCount);
                written += wrCount;
            }
            if ((readAvailable = instance.getBuffered()) <= 0) continue;
            int rCount = instance.readOffset(readBuff, read, readAvailable, 0);
            instance.consumeReadData(rCount);
            read += rCount;
        } while (read != wrData.length || written != wrData.length);
    }

    public void testSomeMultiTest() {
        int Alen = 16;
        int Blen = 32;
        int Clen = 64;
        int Dlen = 256;
        int len = Alen + Blen + Clen + Dlen;
        ByteFifoBuffer fifo = new ByteFifoBuffer(len);
        byte[] A = this.getWData(Alen);
        byte[] B = this.getWData(Blen);
        byte[] C = this.getWData(Clen);
        byte[] D = this.getWData(Dlen);
        byte[] Aread = this.getWData(Alen);
        byte[] Bread = this.getWData(Blen);
        byte[] Cread = this.getWData(Clen);
        byte[] Dread = this.getWData(Dlen);
        fifo.writeOffset(A, Alen, 0);
        fifo.consumeWriteBuffer(Alen);
        fifo.readOffset(Aread, 0, Alen, 0);
        Assert.assertArrayEquals((byte[])A, (byte[])Aread);
    }
}

