/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.Objects;
import com.voxeo.utils.Strings;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.joda.time.DateTime;

public class Excel {
    public static Row renderRow(Sheet sheet, int rowIndex, Object ... values) {
        return Excel.renderRow(sheet, null, rowIndex, values);
    }

    public static Row renderRow(Sheet sheet, CellStyle style, int rowIndex, Object ... values) {
        Row row = sheet.createRow(rowIndex);
        for (int idx = 0; idx < values.length; ++idx) {
            Cell cell = row.createCell(idx);
            Object value = values[idx];
            Excel.setCellValue(cell, style, value);
        }
        return row;
    }

    public static String toCsv(Sheet sheet) {
        StringBuilder builder = new StringBuilder();
        Formatter out = new Formatter(builder);
        for (int rowIndex = 0; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            if (row != null) {
                String comma = "";
                for (int columnIndex = 0; columnIndex <= row.getLastCellNum(); ++columnIndex) {
                    Cell cell = row.getCell(columnIndex);
                    out.format("%s\"%s\"", comma, Excel.value(cell).replace('\"', ' '));
                    comma = ",";
                }
            }
            out.format("\n", new Object[0]);
        }
        out.flush();
        return builder.toString();
    }

    public static Integer intValue(Sheet sheet, String headerName, int rowIndex) {
        Integer result = null;
        String value = Excel.value(sheet, headerName, rowIndex);
        if (!Strings.isEmpty(value)) {
            int dotIndex = value.indexOf(46);
            if (dotIndex > 0) {
                value = value.substring(0, dotIndex);
            }
            result = new Integer(value);
        }
        return result;
    }

    public static Double doubleValue(Sheet sheet, String headerName, int rowIndex) {
        Double result = null;
        String value = Excel.value(sheet, headerName, rowIndex);
        if (!Strings.isEmpty(value)) {
            result = new Double(value);
        }
        return result;
    }

    public static String value(Sheet sheet, String headerName, int rowIndex) {
        Objects.assertion(!Strings.isEmpty(headerName), "empty header name", new Object[0]);
        Row headerRow = sheet.getRow(0);
        String result = null;
        for (int cellIndex = headerRow.getFirstCellNum(); cellIndex >= 0 && cellIndex <= headerRow.getLastCellNum(); ++cellIndex) {
            Cell cell;
            String headerValue;
            Cell headerCell = headerRow.getCell(cellIndex);
            if (headerCell == null || headerCell.getCellType() != 1 || !headerName.equals(headerValue = headerCell.getStringCellValue())) continue;
            Row row = sheet.getRow(rowIndex);
            if (row == null || (cell = row.getCell(cellIndex)) == null) break;
            result = Excel.value(cell);
            break;
        }
        return result;
    }

    public static String value(Sheet sheet, int row, int column) {
        Cell cell = sheet.getRow(row).getCell(column);
        return Excel.value(cell);
    }

    public static String value(Cell cell) {
        String result;
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case 1: {
                result = cell.getStringCellValue();
                break;
            }
            case 2: {
                result = cell.getCellFormula();
                break;
            }
            case 0: {
                result = Double.toString(cell.getNumericCellValue());
                break;
            }
            case 4: {
                result = Boolean.toString(cell.getBooleanCellValue());
                break;
            }
            case 3: {
                result = "";
                break;
            }
            default: {
                throw new AssertionError((Object)("Bad cell type: " + cell.getCellType()));
            }
        }
        return result;
    }

    public static Number getEvaluatedValue(Workbook wb, Sheet sheet, int row, int column) {
        Cell cell = sheet.getRow(row).getCell(column);
        if (cell.getCellType() != 2) {
            throw new IllegalArgumentException("Not a forumla cell");
        }
        FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
        CellValue cellValue = evaluator.evaluate(cell);
        return cellValue.getNumberValue();
    }

    public static void renderCell(Sheet sheet, int rowIndex, int colIndex, ExcelCell cellDef) {
        Cell cell;
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        if ((cell = row.getCell(colIndex)) == null) {
            cell = row.createCell(colIndex);
        }
        int cellType = cellDef.getCellType();
        cell.setCellType(cellType);
        if (cellType == 2) {
            if (cellDef.getStyle() != null) {
                cell.setCellStyle(cellDef.getStyle());
            }
            cell.setCellFormula((String)cellDef.getValue());
        } else {
            Excel.setCellValue(cell, cellDef.getStyle(), cellDef.getValue());
        }
    }

    public static void setCellValue(Cell cell, CellStyle style, Object value) {
        if (style != null) {
            cell.setCellStyle(style);
        }
        if (value instanceof Number) {
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof DateTime) {
            cell.setCellValue(((DateTime)value).toDate());
        } else {
            cell.setCellValue(value.toString());
        }
    }

    public static void setCellValue(Cell cell, Number number, CellStyle style) {
        if (style != null) {
            cell.setCellStyle(style);
        }
        cell.setCellValue(number.doubleValue());
    }

    public static void setCellValue(Cell cell, String value, CellStyle style) {
        if (style != null) {
            cell.setCellStyle(style);
        }
        cell.setCellValue(value);
    }

    public static void setCellValue(Cell cell, Calendar value, CellStyle style) {
        if (style != null) {
            cell.setCellStyle(style);
        }
        cell.setCellValue(value);
    }

    public static String getCellName(int column, int row) {
        String columnName = Excel.itoa(column);
        return String.format("%s%d", columnName, row + 1);
    }

    public static String itoa(int column) {
        String result = Character.toString((char)(65 + column % 26));
        if (column >= 26) {
            result = Excel.itoa(column / 26 - 1) + result;
        }
        return result;
    }

    public static class ExcelCell {
        private CellStyle style;
        private Object value;
        private int cellType = 1;

        public ExcelCell(Object value, CellStyle style) {
            this.style = style;
            this.value = value;
        }

        public ExcelCell(Object value, CellStyle style, int cellType) {
            this.style = style;
            this.value = value;
            this.cellType = cellType;
        }

        public CellStyle getStyle() {
            return this.style;
        }

        public int getCellType() {
            return this.cellType;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

