/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Selector;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

final class SelectorUtil {
    private static final InternalLogger logger;
    static final int DEFAULT_IO_THREADS;

    static void select(Selector selector) throws IOException {
        block2: {
            try {
                selector.select(10L);
            }
            catch (CancelledKeyException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug(CancelledKeyException.class.getSimpleName() + " raised by a Selector - JDK bug?", e);
            }
        }
    }

    private SelectorUtil() {
    }

    static {
        block3: {
            logger = InternalLoggerFactory.getInstance(SelectorUtil.class);
            DEFAULT_IO_THREADS = Runtime.getRuntime().availableProcessors() * 2;
            String key = "sun.nio.ch.bugLevel";
            try {
                String buglevel = System.getProperty(key);
                if (buglevel == null) {
                    System.setProperty(key, "");
                }
            }
            catch (SecurityException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Unable to get/set System Property '" + key + "'", e);
            }
        }
    }
}

