/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.rvproxy;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;
import net.kano.joscar.rvproto.rvproxy.RvProxyPacket;

public class RvProxyAckCmd
extends RvProxyCmd {
    private final InetAddress ip;
    private final int port;

    protected RvProxyAckCmd(RvProxyPacket header) {
        super(header);
        ByteBlock data = header.getCommandData();
        this.port = BinaryTools.getUShort((ByteBlock)data, (int)0);
        this.ip = BinaryTools.getIPFromBytes((ByteBlock)data, (int)2);
    }

    public RvProxyAckCmd(InetAddress ip, int port) {
        super(3);
        DefensiveTools.checkNull((Object)ip, (String)"ip");
        DefensiveTools.checkRange((int)port, (String)"port", (int)-1);
        this.ip = ip;
        this.port = port;
    }

    public final InetAddress getProxyIpAddress() {
        return this.ip;
    }

    public final int getProxyPort() {
        return this.port;
    }

    public void writeCommandData(OutputStream out) throws IOException {
        if (this.port != -1) {
            BinaryTools.writeUShort((OutputStream)out, (int)this.port);
            if (this.ip != null) {
                out.write(this.ip.getAddress());
            }
        }
    }

    public String toString() {
        return "RvProxyAckCmd: ip=" + this.ip + ", port=" + this.port;
    }
}

