/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.remotebitrateestimator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.fmj.media.rtp.util.RTPPacket;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.BandwidthUsage;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.CallStatsObserver;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.OveruseDetector;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RateControlInput;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RateControlRegion;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RateStatistics;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RecurringProcessible;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RemoteBitrateObserver;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RemoteRateControl;
import org.jitsi.service.neomedia.rtp.RemoteBitrateEstimator;

public class RemoteBitrateEstimatorSingleStream
implements CallStatsObserver,
RecurringProcessible,
RemoteBitrateEstimator {
    private static final int kProcessIntervalMs = 1000;
    private static final int kStreamTimeOutMs = 2000;
    private final Object critSect = new Object();
    private final RateStatistics incomingBitrate = new RateStatistics(500, 8000.0f);
    private final RateControlInput input = new RateControlInput(BandwidthUsage.kBwNormal, 0L, 0.0);
    private long lastProcessTime = -1L;
    private final RemoteBitrateObserver observer;
    private final Map<Integer, OveruseDetector> overuseDetectors = new HashMap<Integer, OveruseDetector>();
    private final RemoteRateControl remoteRate;
    private Collection<Integer> ssrcs;

    public RemoteBitrateEstimatorSingleStream(RemoteBitrateObserver observer, long minBitrateBps) {
        this.observer = observer;
        this.remoteRate = new RemoteRateControl(minBitrateBps);
    }

    private long getExtensionTransmissionTimeOffset(RTPPacket header) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatestEstimate() {
        long bitrateBps;
        Object object = this.critSect;
        synchronized (object) {
            bitrateBps = this.remoteRate.isValidEstimate() ? (this.getSsrcs().isEmpty() ? 0L : this.remoteRate.getLatestEstimate()) : -1L;
        }
        return bitrateBps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Integer> getSsrcs() {
        Object object = this.critSect;
        synchronized (object) {
            if (this.ssrcs == null) {
                this.ssrcs = Collections.unmodifiableCollection(new ArrayList<Integer>(this.overuseDetectors.keySet()));
            }
            return this.ssrcs;
        }
    }

    @Override
    public long getTimeUntilNextProcess() {
        return this.lastProcessTime < 0L ? 0L : this.lastProcessTime + 1000L - System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incomingPacket(long arrivalTimeMs, int payloadSize, int ssrc, long rtpTimestamp) {
        Integer ssrc_ = ssrc;
        long nowMs = System.currentTimeMillis();
        Object object = this.critSect;
        synchronized (object) {
            OveruseDetector overuseDetector = this.overuseDetectors.get(ssrc_);
            if (overuseDetector == null) {
                overuseDetector = new OveruseDetector();
                this.overuseDetectors.put(ssrc_, overuseDetector);
                this.ssrcs = null;
            }
            overuseDetector.setPacketTimeMs(nowMs);
            this.incomingBitrate.update(payloadSize, nowMs);
            BandwidthUsage priorState = overuseDetector.getState();
            overuseDetector.update(payloadSize, -1L, rtpTimestamp, arrivalTimeMs);
            if (overuseDetector.getState() == BandwidthUsage.kBwOverusing) {
                long incomingBitrate = this.incomingBitrate.getRate(nowMs);
                if (priorState != BandwidthUsage.kBwOverusing || this.remoteRate.isTimeToReduceFurther(nowMs, incomingBitrate)) {
                    this.updateEstimate(nowMs);
                }
            }
        }
    }

    @Override
    public void incomingPacket(long arrivalTimeMs, int payloadSize, RTPPacket header) {
        int ssrc = header.ssrc;
        long rtpTimestamp = header.timestamp + this.getExtensionTransmissionTimeOffset(header);
        this.incomingPacket(arrivalTimeMs, payloadSize, ssrc, rtpTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRttUpdate(long rtt) {
        Object object = this.critSect;
        synchronized (object) {
            this.remoteRate.setRtt(rtt);
        }
    }

    @Override
    public long process() {
        if (this.getTimeUntilNextProcess() <= 0L) {
            long nowMs = System.currentTimeMillis();
            this.updateEstimate(nowMs);
            this.lastProcessTime = nowMs;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStream(int ssrc) {
        Object object = this.critSect;
        synchronized (object) {
            this.overuseDetectors.remove(ssrc);
            this.ssrcs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEstimate(long nowMs) {
        Object object = this.critSect;
        synchronized (object) {
            RemoteBitrateObserver observer;
            BandwidthUsage bwState = BandwidthUsage.kBwNormal;
            double sumNoiseVar = 0.0;
            Iterator<OveruseDetector> it = this.overuseDetectors.values().iterator();
            while (it.hasNext()) {
                OveruseDetector overuseDetector = it.next();
                long packetTimeMs = overuseDetector.getPacketTimeMs();
                if (packetTimeMs >= 0L && nowMs - packetTimeMs > 2000L) {
                    it.remove();
                    this.ssrcs = null;
                    continue;
                }
                sumNoiseVar += overuseDetector.getNoiseVar();
                BandwidthUsage overuseDetectorBwState = overuseDetector.getState();
                if (overuseDetectorBwState.ordinal() <= bwState.ordinal()) continue;
                bwState = overuseDetectorBwState;
            }
            if (this.overuseDetectors.isEmpty()) {
                this.remoteRate.reset();
                return;
            }
            double meanNoiseVar = sumNoiseVar / (double)this.overuseDetectors.size();
            RateControlInput input = this.input;
            input.bwState = bwState;
            input.incomingBitRate = this.incomingBitrate.getRate(nowMs);
            input.noiseVar = meanNoiseVar;
            RateControlRegion region = this.remoteRate.update(input, nowMs);
            long targetBitrate = this.remoteRate.updateBandwidthEstimate(nowMs);
            if (this.remoteRate.isValidEstimate() && (observer = this.observer) != null) {
                observer.onReceiveBitrateChanged(this.getSsrcs(), targetBitrate);
            }
            for (OveruseDetector overuseDetector : this.overuseDetectors.values()) {
                overuseDetector.setRateControlRegion(region);
            }
        }
    }
}

