/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.UIManager;
import net.sf.fmj.media.RegistryDefaults;
import net.sf.fmj.utility.ClasspathChecker;
import net.sf.fmj.utility.JmfUtility;
import net.sf.fmj.utility.LoggerSingleton;

public class FmjStartup {
    private static final Logger logger = LoggerSingleton.logger;
    private static boolean initialized = false;
    public static boolean isApplet = false;

    public static final void init() {
        if (initialized) {
            return;
        }
        logger.info("OS: " + System.getProperty("os.name"));
        System.setProperty("java.util.logging.config.file", "logging.properties");
        try {
            LogManager.getLogManager().readConfiguration();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Unable to read logging configuration: " + exception, exception);
            System.err.println("Unable to read logging configuration: " + exception);
            exception.printStackTrace();
        }
        if (!ClasspathChecker.checkAndWarn()) {
            logger.info("Enabling JMF logging");
            if (!JmfUtility.enableLogging()) {
                logger.warning("Failed to enable JMF logging");
            }
            logger.info("Registering FMJ prefixes and plugins with JMF");
            RegistryDefaults.registerAll(10);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "" + exception, exception);
        }
        initialized = true;
    }

    public static final void initApplet() {
        if (initialized) {
            return;
        }
        if (!ClasspathChecker.checkAndWarn()) {
            logger.info("Enabling JMF logging");
            if (!JmfUtility.enableLogging()) {
                logger.warning("Failed to enable JMF logging");
            }
            logger.info("Registering FMJ prefixes and plugins with JMF");
            RegistryDefaults.registerAll(2);
        }
        initialized = true;
    }
}

