/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.jnodes.jingle;

import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Packet;
import org.xmpp.jnodes.jingle.Jingle;
import org.xmpp.jnodes.jingle.JingleContent;
import org.xmpp.jnodes.jingle.JingleIQ;
import org.xmpp.jnodes.jingle.JingleInfoRing;
import org.xmpp.jnodes.jingle.JingleSessionListener;
import org.xmpp.jnodes.jingle.MediaProvider;
import org.xmpp.jnodes.jingle.RawUdpTransportProvider;
import org.xmpp.jnodes.smack.JingleChannelIQ;

public class JingleSession {
    private final JingleIQ sessionInitiate;
    private JingleIQ sessionInfo;
    private JingleIQ sessionAccept;
    private JingleIQ sessionTerminate;
    private JingleChannelIQ jingleChannelIQ;
    private final boolean outbound;
    private final ConcurrentHashMap<JingleSessionListener, JingleSessionListener> sessionListeners = new ConcurrentHashMap();
    private final MediaProvider mediaProvider;
    private final RawUdpTransportProvider rawUdpTransportProvider;
    private final XMPPConnection connection;

    public JingleSession(JingleIQ sessionInitiate, boolean outbound, MediaProvider mediaProvider, RawUdpTransportProvider rawUdpTransportProvider, XMPPConnection connection) {
        if (sessionInitiate == null) {
            throw new IllegalArgumentException("SessionInitiate cannot be null");
        }
        this.sessionInitiate = sessionInitiate;
        this.outbound = outbound;
        this.mediaProvider = mediaProvider;
        this.rawUdpTransportProvider = rawUdpTransportProvider;
        this.connection = connection;
    }

    public boolean isAccepted() {
        return this.sessionAccept != null;
    }

    public boolean isTerminated() {
        return this.sessionTerminate != null;
    }

    public boolean isOutbound() {
        return this.outbound;
    }

    public JingleIQ getSessionInitiate() {
        return this.sessionInitiate;
    }

    public JingleIQ getSessionInfo() {
        return this.sessionInfo;
    }

    public JingleIQ getSessionAccept() {
        return this.sessionAccept;
    }

    public JingleIQ getSessionTerminate() {
        return this.sessionTerminate;
    }

    public JingleChannelIQ getJingleChannelIQ() {
        return this.jingleChannelIQ;
    }

    public void setJingleChannelIQ(JingleChannelIQ jingleChannelIQ) {
        this.jingleChannelIQ = jingleChannelIQ;
    }

    public void addJingleSessionListener(JingleSessionListener listener) {
        this.sessionListeners.put(listener, listener);
    }

    public void processJingleIQ(JingleIQ iq) {
        if (this.isSession(iq)) {
            String sa = iq.getJingle().getAction();
            if ("session-info".equals(sa)) {
                this.sessionInfo = iq;
            } else if ("session-accept".equals(sa)) {
                this.sessionAccept = iq;
            } else if ("session-terminate".equals(sa)) {
                this.sessionTerminate = iq;
            }
            for (JingleSessionListener sl : this.sessionListeners.values()) {
                sl.stateChanged(iq);
            }
        }
    }

    public boolean isSession(JingleIQ iq) {
        return iq.getJingle().getSid().equals(this.sessionInitiate.getJingle().getSid()) && iq.getJingle().getInitiator().equals(this.sessionInitiate.getJingle().getInitiator());
    }

    public void ring() {
        if (!this.outbound && this.sessionInfo == null) {
            Jingle j = new Jingle();
            j.setAction("session-info");
            j.setInitiator(this.sessionInitiate.getJingle().getInitiator());
            j.setResponder(this.connection.getUser());
            j.setRinging(new JingleInfoRing());
            JingleIQ iq = new JingleIQ(j);
            iq.setFrom(this.connection.getUser());
            iq.setTo(this.sessionInitiate.getFrom());
            this.connection.sendPacket((Packet)iq);
        }
    }

    public void accept() {
        if (!this.outbound && this.sessionAccept == null) {
            Jingle j = new Jingle();
            j.setAction("session-accept");
            j.setInitiator(this.sessionInitiate.getJingle().getInitiator());
            j.setResponder(this.connection.getUser());
            j.getContents().clear();
            for (JingleContent content : this.mediaProvider.getJingleContents()) {
                content.setCreator("initiator");
                content.setName(this.connection.getUser());
                j.addContent(content);
            }
            this.rawUdpTransportProvider.setupTransport(j.getContents());
            JingleIQ accept = new JingleIQ(j);
            this.connection.sendPacket((Packet)accept);
        }
    }
}

