/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.jnodes.jingle;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.List;

public abstract class JingleElement {
    public String getChildElementXML() {
        StringBuilder sub = new StringBuilder();
        StringBuilder str = new StringBuilder("<");
        str.append(this.getElementName()).append(" ");
        for (Field f : this.getClass().getDeclaredFields()) {
            if (f.isAnnotationPresent(Skip.class)) continue;
            try {
                Object o = f.get(this);
                String value = this.gen(o);
                if (o instanceof List || o instanceof JingleElement) {
                    sub.append(value);
                    continue;
                }
                if (value == null || value.length() <= 0) continue;
                str.append(f.getName()).append("='").append(value).append("' ");
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        if (sub.length() == 0) {
            str.append("/>");
        } else {
            str.append(">");
            str.append(sub.toString());
            str.append("</").append(this.getElementName()).append(">");
        }
        return str.toString();
    }

    private String gen(Object o) {
        String value;
        if (o instanceof List) {
            StringBuilder s = new StringBuilder();
            for (Object oo : (List)o) {
                String partial = this.gen(oo);
                if (partial == null) continue;
                s.append(partial);
            }
            value = s.toString();
        } else {
            value = o instanceof JingleElement ? ((JingleElement)o).getChildElementXML() : (o instanceof String ? o.toString() : null);
        }
        return value;
    }

    public abstract String getElementName();

    public static String getNamespace(Class c) {
        try {
            Field f = c.getField("xmlns");
            return (String)f.get(c);
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public static String getStaticElementName(Class c) {
        try {
            Field f = c.getField("elementName");
            return (String)f.get(c);
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Skip {
    }
}

