/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.simulcast;

import java.net.DatagramPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RateStatistics;
import org.jitsi.util.Logger;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.videobridge.simulcast.SimulcastManager;
import org.jitsi.videobridge.simulcast.StringCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulcastLayer
extends PropertyChangeNotifier
implements Comparable<SimulcastLayer> {
    private static final int MAX_SEEN_BASE = 25;
    private static final int INCOMING_BITRATE_INTERVAL_MS = 5000;
    private final RateStatistics rateStatistics = new RateStatistics(5000, 8000.0f);
    private final SimulcastManager simulcastManager;
    private static final Logger logger = Logger.getLogger(SimulcastLayer.class);
    public static final String IS_STREAMING_PROPERTY = SimulcastLayer.class.getName() + ".isStreaming";
    private int seenHigh = -1;
    private final long primarySSRC;
    private final Set<Long> associatedSSRCs = new HashSet<Long>();
    private final int order;
    private boolean isStreaming = false;
    private int seenBase = 0;

    public SimulcastManager getSimulcastManager() {
        return this.simulcastManager;
    }

    public long getPrimarySSRC() {
        return this.primarySSRC;
    }

    public int getOrder() {
        return this.order;
    }

    public SimulcastLayer(SimulcastManager manager, long primarySSRC, int order) {
        this.simulcastManager = manager;
        this.primarySSRC = primarySSRC;
        this.order = order;
    }

    public boolean accept(long ssrc) {
        return ssrc == this.primarySSRC || this.associatedSSRCs != null && this.associatedSSRCs.contains(ssrc);
    }

    public void associateSSRCs(Set<Long> ssrcs) {
        this.associatedSSRCs.addAll(ssrcs);
    }

    @Override
    public int compareTo(SimulcastLayer o) {
        return this.order - o.order;
    }

    public List<Long> getAssociatedSSRCs() {
        return new ArrayList<Long>(this.associatedSSRCs);
    }

    public boolean isStreaming() {
        return this.isStreaming ? this.isStreaming : this.order == 0;
    }

    public synchronized void maybeTimeout() {
        if (++this.seenBase % 25 == 0) {
            if (this.isStreaming && this.seenHigh == 0) {
                this.isStreaming = false;
                if (logger.isDebugEnabled()) {
                    HashMap<String, Object> map = new HashMap<String, Object>(2);
                    map.put("parent", this.getSimulcastManager().getVideoChannel().getEndpoint());
                    map.put("self", this);
                    StringCompiler sc = new StringCompiler(map);
                    logger.debug((Object)sc.c("{parent.id} stopped streaming its order-{self.order} layer ({self.primarySSRC})."));
                }
                new Thread(new Runnable(){

                    public void run() {
                        SimulcastLayer.this.firePropertyChange(IS_STREAMING_PROPERTY, true, false);
                    }
                }).start();
            }
            this.seenHigh = 0;
        }
    }

    public synchronized void touch() {
        ++this.seenHigh;
        if (!this.isStreaming) {
            this.isStreaming = true;
            if (logger.isDebugEnabled()) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("parent", this.getSimulcastManager().getVideoChannel().getEndpoint());
                map.put("self", this);
                StringCompiler sc = new StringCompiler(map);
                logger.debug((Object)sc.c("{parent.id} started streaming its order-{self.order} layer ({self.primarySSRC})."));
            }
            new Thread(new Runnable(){

                public void run() {
                    SimulcastLayer.this.firePropertyChange(IS_STREAMING_PROPERTY, false, true);
                }
            }).start();
        }
    }

    public long getBitrate() {
        return this.rateStatistics.getRate(System.currentTimeMillis());
    }

    public void acceptedDataInputStreamDatagramPacket(DatagramPacket p) {
        if (p != null) {
            this.rateStatistics.update(p.getLength(), System.currentTimeMillis());
        }
    }
}

