/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RawUdpTransportPacketExtension;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.videobridge.Channel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransportManager {
    private static long nextCandidateID = 1L;
    private final PropertyChangeListener channelPropertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            TransportManager.this.channelPropertyChange(ev);
        }
    };
    private final List<Channel> channels = new LinkedList<Channel>();

    protected TransportManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChannel(Channel channel) {
        List<Channel> list = this.channels;
        synchronized (list) {
            if (!this.channels.contains((Object)channel)) {
                this.channels.add(channel);
                channel.addPropertyChangeListener(this.channelPropertyChangeListener);
                return true;
            }
        }
        return false;
    }

    protected void channelPropertyChange(PropertyChangeEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<Channel> list = this.channels;
        synchronized (list) {
            for (Channel channel : this.channels) {
                this.close(channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(Channel channel) {
        if (channel != null) {
            channel.removePropertyChangeListener(this.channelPropertyChangeListener);
        }
        List<Channel> list = this.channels;
        synchronized (list) {
            return this.channels.remove((Object)channel);
        }
    }

    public void describe(ColibriConferenceIQ.ChannelBundle iq) {
        Object pe = iq.getTransport();
        String namespace = this.getXmlNamespace();
        if (pe == null || !namespace.equals(pe.getNamespace())) {
            pe = "urn:xmpp:jingle:transports:ice-udp:1".equals(namespace) ? new IceUdpTransportPacketExtension() : ("urn:xmpp:jingle:transports:raw-udp:1".equals(namespace) ? new RawUdpTransportPacketExtension() : null);
            iq.setTransport(pe);
        }
        if (pe != null) {
            this.describe((IceUdpTransportPacketExtension)pe);
        }
    }

    public void describe(ColibriConferenceIQ.ChannelCommon iq) {
        Object pe = iq.getTransport();
        String namespace = this.getXmlNamespace();
        if (pe == null || !namespace.equals(pe.getNamespace())) {
            pe = "urn:xmpp:jingle:transports:ice-udp:1".equals(namespace) ? new IceUdpTransportPacketExtension() : ("urn:xmpp:jingle:transports:raw-udp:1".equals(namespace) ? new RawUdpTransportPacketExtension() : null);
            iq.setTransport(pe);
        }
        if (pe != null) {
            this.describe((IceUdpTransportPacketExtension)pe);
        }
    }

    protected abstract void describe(IceUdpTransportPacketExtension var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateCandidateID() {
        Class<TransportManager> clazz = TransportManager.class;
        synchronized (TransportManager.class) {
            long candidateID = nextCandidateID++;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            return Long.toHexString(candidateID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Channel> getChannels() {
        List<Channel> list = this.channels;
        synchronized (list) {
            return this.channels;
        }
    }

    public abstract DtlsControl getDtlsControl(Channel var1);

    public abstract StreamConnector getStreamConnector(Channel var1);

    public abstract MediaStreamTarget getStreamTarget(Channel var1);

    public abstract String getXmlNamespace();

    public abstract void startConnectivityEstablishment(IceUdpTransportPacketExtension var1);
}

