/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;

public abstract class AbstractProtocolProviderService
implements ProtocolProviderService {
    private static final Logger logger = Logger.getLogger(AbstractProtocolProviderService.class);
    private final List<RegistrationStateChangeListener> registrationListeners = new ArrayList<RegistrationStateChangeListener>();
    private final Map<String, OperationSet> supportedOperationSets = new Hashtable<String, OperationSet>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegistrationStateChangeListener(RegistrationStateChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        List<RegistrationStateChangeListener> list = this.registrationListeners;
        synchronized (list) {
            if (!this.registrationListeners.contains(listener)) {
                this.registrationListeners.add(listener);
            }
        }
    }

    protected <T extends OperationSet> void addSupportedOperationSet(Class<T> opsetClass, T opset) {
        this.supportedOperationSets.put(opsetClass.getName(), opset);
    }

    protected <T extends OperationSet> void removeSupportedOperationSet(Class<T> opsetClass) {
        this.supportedOperationSets.remove(opsetClass.getName());
    }

    protected void clearSupportedOperationSet() {
        this.supportedOperationSets.clear();
    }

    public void fireRegistrationStateChanged(RegistrationState oldState, RegistrationState newState, int reasonCode, String reason) {
        this.fireRegistrationStateChanged(oldState, newState, reasonCode, reason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRegistrationStateChanged(RegistrationState oldState, RegistrationState newState, int reasonCode, String reason, boolean userRequest) {
        RegistrationStateChangeListener[] listeners;
        RegistrationStateChangeEvent event = new RegistrationStateChangeEvent(this, oldState, newState, reasonCode, reason);
        event.setUserRequest(userRequest);
        List<RegistrationStateChangeListener> list = this.registrationListeners;
        synchronized (list) {
            listeners = this.registrationListeners.toArray(new RegistrationStateChangeListener[this.registrationListeners.size()]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching " + event + " to " + listeners.length + " listeners."));
        }
        for (RegistrationStateChangeListener listener : listeners) {
            try {
                listener.registrationStateChanged(event);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                logger.error((Object)("An error occurred while executing RegistrationStateChangeListener#registrationStateChanged(RegistrationStateChangeEvent) of " + listener), throwable);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Done.");
        }
    }

    @Override
    public <T extends OperationSet> T getOperationSet(Class<T> opsetClass) {
        return (T)this.supportedOperationSets.get(opsetClass.getName());
    }

    @Override
    public String getProtocolDisplayName() {
        String displayName = this.getAccountID().getAccountPropertyString("PROTOCOL_NAME");
        return displayName == null ? this.getProtocolName() : displayName;
    }

    @Override
    public Map<String, OperationSet> getSupportedOperationSets() {
        return new Hashtable<String, OperationSet>(this.supportedOperationSets);
    }

    @Override
    public Collection<Class<? extends OperationSet>> getSupportedOperationSetClasses() {
        ArrayList<Class<? extends OperationSet>> opSetClasses = new ArrayList<Class<? extends OperationSet>>();
        for (String opSetClassName : this.getSupportedOperationSets().keySet()) {
            try {
                opSetClasses.add(this.getSupportedOperationSets().get(opSetClassName).getClass().getClassLoader().loadClass(opSetClassName));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return opSetClasses;
    }

    @Override
    public boolean isRegistered() {
        return this.getRegistrationState().equals(RegistrationState.REGISTERED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegistrationStateChangeListener(RegistrationStateChangeListener listener) {
        List<RegistrationStateChangeListener> list = this.registrationListeners;
        synchronized (list) {
            this.registrationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRegistrationStateChangeListener() {
        List<RegistrationStateChangeListener> list = this.registrationListeners;
        synchronized (list) {
            this.registrationListeners.clear();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getAccountID().getDisplayName() + ")";
    }

    @Override
    public void unregister(boolean userRequest) throws OperationFailedException {
        this.unregister();
    }
}

