/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.protocol.xmpp.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaSSRCMap {
    private Map<String, List<SourcePacketExtension>> ssrcs = new HashMap<String, List<SourcePacketExtension>>();

    public MediaSSRCMap() {
        this.ssrcs = new HashMap<String, List<SourcePacketExtension>>();
    }

    private MediaSSRCMap(Map<String, List<SourcePacketExtension>> ssrcs) {
        this.ssrcs = ssrcs;
    }

    public List<SourcePacketExtension> getSSRCsForMedia(String media) {
        List<SourcePacketExtension> ssrcList = this.ssrcs.get(media);
        if (ssrcList == null) {
            ssrcList = new ArrayList<SourcePacketExtension>();
            this.ssrcs.put(media, ssrcList);
        }
        return ssrcList;
    }

    public Set<String> getMediaTypes() {
        return this.ssrcs.keySet();
    }

    public void add(MediaSSRCMap mapToMerge) {
        for (String media : mapToMerge.ssrcs.keySet()) {
            List<SourcePacketExtension> ssrcList = this.getSSRCsForMedia(media);
            ssrcList.addAll((Collection<SourcePacketExtension>)mapToMerge.ssrcs.get(media));
        }
    }

    public void remove(MediaSSRCMap mapToRemove) {
        for (String media : mapToRemove.ssrcs.keySet()) {
            List<SourcePacketExtension> ssrcList = this.getSSRCsForMedia(media);
            ArrayList<SourcePacketExtension> toBeRemoved = new ArrayList<SourcePacketExtension>();
            for (SourcePacketExtension ssrcToCheck : mapToRemove.ssrcs.get(media)) {
                for (SourcePacketExtension ssrc : ssrcList) {
                    if (ssrcToCheck.getSSRC() != ssrc.getSSRC()) continue;
                    toBeRemoved.add(ssrc);
                }
            }
            ssrcList.removeAll(toBeRemoved);
        }
    }

    public MediaSSRCMap copyShallow() {
        HashMap<String, List<SourcePacketExtension>> mapCopy = new HashMap<String, List<SourcePacketExtension>>();
        for (String media : this.ssrcs.keySet()) {
            ArrayList listCopy = new ArrayList(this.ssrcs.get(media));
            mapCopy.put(media, listCopy);
        }
        return new MediaSSRCMap(mapCopy);
    }

    public boolean isEmpty() {
        for (String media : this.ssrcs.keySet()) {
            if (this.getSSRCsForMedia(media).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static MediaSSRCMap getSSRCsFromContent(List<ContentPacketExtension> contents) {
        HashMap<String, List<SourcePacketExtension>> ssrcMap = new HashMap<String, List<SourcePacketExtension>>();
        for (ContentPacketExtension content : contents) {
            List ssrcPe;
            String media;
            RtpDescriptionPacketExtension rtpDesc = (RtpDescriptionPacketExtension)content.getFirstChildOfType(RtpDescriptionPacketExtension.class);
            if (rtpDesc != null) {
                media = rtpDesc.getMedia();
                ssrcPe = rtpDesc.getChildExtensionsOfType(SourcePacketExtension.class);
            } else {
                media = content.getName();
                ssrcPe = content.getChildExtensionsOfType(SourcePacketExtension.class);
            }
            ssrcMap.put(media, ssrcPe);
        }
        return new MediaSSRCMap(ssrcMap);
    }
}

