/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.recording;

import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.util.Logger;
import org.jitsi.jicofo.recording.Recorder;
import org.jitsi.protocol.xmpp.OperationSetDirectSmackXmpp;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;

public class JvbRecorder
extends Recorder {
    private static final Logger logger = Logger.getLogger(JvbRecorder.class);
    private final String conferenceId;
    boolean isRecording;

    public JvbRecorder(String conferenceId, String videoBridgeComponentJid, OperationSetDirectSmackXmpp xmpp) {
        super(videoBridgeComponentJid, xmpp);
        this.conferenceId = conferenceId;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setRecording(String from, String token, boolean doRecord, String path) {
        ColibriConferenceIQ toggleRecordingIq = new ColibriConferenceIQ();
        toggleRecordingIq.setID(this.conferenceId);
        toggleRecordingIq.setTo(this.recorderComponentJid);
        toggleRecordingIq.setType(IQ.Type.SET);
        toggleRecordingIq.setRecording(new ColibriConferenceIQ.Recording(!this.isRecording, token));
        Packet reply = this.xmpp.getXmppConnection().sendPacketAndGetReply((Packet)toggleRecordingIq);
        logger.info((Object)("REC reply received: " + reply.toXML()));
        if (reply instanceof ColibriConferenceIQ) {
            ColibriConferenceIQ colibriReply = (ColibriConferenceIQ)reply;
            ColibriConferenceIQ.Recording recording = colibriReply.getRecording();
            if (recording == null) return false;
            this.isRecording = recording.getState();
            logger.info((Object)("REC status: " + this.conferenceId + ": " + this.isRecording));
            return true;
        } else {
            logger.error((Object)(this.conferenceId + " unexpected response received: " + reply.toXML()));
        }
        return true;
    }

    public boolean accept(Packet packet) {
        return false;
    }

    public void processPacket(Packet packet) {
    }
}

