/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.log;

import org.jitsi.videobridge.log.Event;

public class LogEventFactory {
    private static final String[] FOCUS_CREATED_COLUMNS = new String[]{"room_jid"};
    private static final String[] ENDPOINT_DISPLAY_NAME_COLUMNS = new String[]{"conference_id", "endpoint_id", "display_name"};
    private static final String[] PEER_CONNECTION_STATS_COLUMNS = new String[]{"conference_id", "endpoint_id", "stats"};
    private static final String[] CONFERENCE_ROOM_COLUMNS = new String[]{"conference_id", "room_jid"};

    public static Event focusCreated(String roomJid) {
        return new Event("focus_created", FOCUS_CREATED_COLUMNS, new Object[]{roomJid});
    }

    public static Event endpointDisplayNameChanged(String conferenceId, String endpointId, String displayName) {
        return new Event("endpoint_display_name", ENDPOINT_DISPLAY_NAME_COLUMNS, new Object[]{conferenceId, endpointId, displayName});
    }

    public static Event peerConnectionStats(String conferenceId, String endpointId, String stats) {
        return new Event("peer_connection_stats", PEER_CONNECTION_STATS_COLUMNS, new Object[]{conferenceId, endpointId, stats});
    }

    public static Event conferenceRoom(String conferenceId, String roomJid) {
        return new Event("conference_room", CONFERENCE_ROOM_COLUMNS, new Object[]{conferenceId, roomJid});
    }
}

