/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.java.sip.communicator.impl.protocol.jabber.extensions.caps.EntityCapsManager;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.jicofo.FocusManager;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.videobridge.log.LoggingService;
import org.jitsi.videobridge.osgi.ServiceUtils2;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class FocusBundleActivator
implements BundleActivator {
    private static final int SHARED_POOL_SIZE = 20;
    public static BundleContext bundleContext;
    private static ConfigurationService configService;
    private FocusManager focusManager;
    private static ExecutorService sharedThreadPool;

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        EntityCapsManager.setBundleContext((BundleContext)context);
        sharedThreadPool = Executors.newFixedThreadPool(20);
        context.registerService(ExecutorService.class, (Object)sharedThreadPool, null);
        this.focusManager = new FocusManager();
        context.registerService(FocusManager.class, (Object)this.focusManager, null);
    }

    public void stop(BundleContext context) throws Exception {
        sharedThreadPool.shutdownNow();
        sharedThreadPool = null;
        configService = null;
        EntityCapsManager.setBundleContext(null);
    }

    public static ConfigurationService getConfigService() {
        if (configService == null) {
            configService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configService;
    }

    public static LoggingService getLoggingService() {
        if (bundleContext != null) {
            return (LoggingService)ServiceUtils2.getService((BundleContext)bundleContext, LoggingService.class);
        }
        return null;
    }

    public static ExecutorService getSharedThreadPool() {
        return sharedThreadPool;
    }
}

