/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.protocol.xmpp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.ScServiceDiscoveryManager;
import net.java.sip.communicator.service.protocol.AbstractProtocolProviderService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ProtocolIcon;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.TransportProtocol;
import net.java.sip.communicator.service.protocol.jabber.JabberAccountID;
import org.jitsi.impl.protocol.xmpp.OpSetDirectSmackXmppImpl;
import org.jitsi.impl.protocol.xmpp.OpSetSimpleCapsImpl;
import org.jitsi.impl.protocol.xmpp.OpSetSubscriptionImpl;
import org.jitsi.impl.protocol.xmpp.OperationSetColibriConferenceImpl;
import org.jitsi.impl.protocol.xmpp.OperationSetJingleImpl;
import org.jitsi.impl.protocol.xmpp.OperationSetMultiUserChatImpl;
import org.jitsi.protocol.xmpp.OperationSetColibriConference;
import org.jitsi.protocol.xmpp.OperationSetDirectSmackXmpp;
import org.jitsi.protocol.xmpp.OperationSetJingle;
import org.jitsi.protocol.xmpp.OperationSetSimpleCaps;
import org.jitsi.protocol.xmpp.OperationSetSubscription;
import org.jitsi.protocol.xmpp.XmppConnection;
import org.jitsi.util.Logger;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppProtocolProvider
extends AbstractProtocolProviderService {
    private static final Logger logger = Logger.getLogger(XmppProtocolProvider.class);
    private final JabberAccountID jabberAccountID;
    private final OperationSetJingleImpl jingleOpSet;
    private RegistrationState registrationState = RegistrationState.UNREGISTERED;
    private XMPPConnection connection;
    private OperationSetColibriConferenceImpl colibriTools = new OperationSetColibriConferenceImpl();
    private XmppConnectionAdapter connectionAdapter;
    private ScServiceDiscoveryManager discoInfoManager;

    public XmppProtocolProvider(AccountID accountID) {
        this.jabberAccountID = (JabberAccountID)accountID;
        this.addSupportedOperationSet(OperationSetColibriConference.class, this.colibriTools);
        this.jingleOpSet = new OperationSetJingleImpl(this);
        this.addSupportedOperationSet(OperationSetJingle.class, this.jingleOpSet);
        this.addSupportedOperationSet(OperationSetMultiUserChat.class, (OperationSet)new OperationSetMultiUserChatImpl(this));
        this.addSupportedOperationSet(OperationSetSimpleCaps.class, new OpSetSimpleCapsImpl(this));
        this.addSupportedOperationSet(OperationSetDirectSmackXmpp.class, new OpSetDirectSmackXmppImpl(this));
        this.addSupportedOperationSet(OperationSetSubscription.class, new OpSetSubscriptionImpl(this));
    }

    public synchronized void register(SecurityAuthority securityAuthority) throws OperationFailedException {
        String serviceName = StringUtils.parseServer((String)this.getAccountID().getUserID());
        String serverAddressUserSetting = this.jabberAccountID.getServerAddress();
        int serverPort = this.getAccountID().getAccountPropertyInt((Object)"SERVER_PORT", 5222);
        ConnectionConfiguration connConfig = new ConnectionConfiguration(serverAddressUserSetting, serverPort, serviceName);
        this.connection = new XMPPConnection(connConfig);
        try {
            this.connection.connect();
            if (this.jabberAccountID.isAnonymousAuthUsed()) {
                this.connection.loginAnonymously();
            } else {
                String login = this.jabberAccountID.getAuthorizationName();
                String pass = this.jabberAccountID.getPassword();
                String resource = this.jabberAccountID.getResource();
                this.connection.login(login, pass, resource);
            }
        }
        catch (XMPPException e) {
            throw new OperationFailedException("Failed to connect", 1, (Throwable)e);
        }
        this.colibriTools.initialize(this.getConnectionAdapter());
        this.jingleOpSet.initialize();
        this.discoInfoManager = new ScServiceDiscoveryManager((ProtocolProviderService)this, this.connection, new String[0], new String[0]);
        this.registrationState = RegistrationState.REGISTERED;
        this.fireRegistrationStateChanged(RegistrationState.UNREGISTERED, RegistrationState.REGISTERED, -1, null);
        logger.info((Object)("XMPP provider " + this.jabberAccountID + " connected (JID: " + this.connection.getUser() + ")"));
    }

    public synchronized void unregister() throws OperationFailedException {
        if (this.connection != null) {
            this.connection.disconnect();
            logger.info((Object)("XMPP provider " + this.jabberAccountID + " disconnected"));
            RegistrationState prevState = this.registrationState;
            this.registrationState = RegistrationState.UNREGISTERED;
            this.fireRegistrationStateChanged(prevState, RegistrationState.UNREGISTERED, -1, null);
            this.connection = null;
        }
    }

    public RegistrationState getRegistrationState() {
        return this.registrationState;
    }

    public String getProtocolName() {
        return "Jabber";
    }

    public ProtocolIcon getProtocolIcon() {
        return null;
    }

    public void shutdown() {
        if (this.connection != null) {
            try {
                this.unregister();
            }
            catch (OperationFailedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public AccountID getAccountID() {
        return this.jabberAccountID;
    }

    public boolean isSignalingTransportSecure() {
        return false;
    }

    public TransportProtocol getTransportProtocol() {
        return TransportProtocol.UNKNOWN;
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    public String getOurJid() {
        return this.connection != null ? this.connection.getUser() : null;
    }

    XmppConnection getConnectionAdapter() {
        if (this.connectionAdapter == null) {
            this.connectionAdapter = new XmppConnectionAdapter(this.connection);
        }
        return this.connectionAdapter;
    }

    public boolean checkFeatureSupport(String contactAddress, String[] features) {
        try {
            logger.debug((Object)("Discovering info for: " + contactAddress));
            DiscoverInfo info = this.discoInfoManager.discoverInfo(contactAddress);
            logger.debug((Object)("HAVE Discovering info for: " + contactAddress));
            logger.debug((Object)"Features");
            Iterator featuresList = info.getFeatures();
            while (featuresList.hasNext()) {
                DiscoverInfo.Feature f = (DiscoverInfo.Feature)featuresList.next();
                logger.debug((Object)f.toXML());
            }
            logger.debug((Object)"Identities");
            Iterator identities = info.getIdentities();
            while (identities.hasNext()) {
                DiscoverInfo.Identity identity = (DiscoverInfo.Identity)identities.next();
                logger.debug((Object)identity.toXML());
            }
        }
        catch (XMPPException e) {
            logger.error((Object)"Error discovering features", (Throwable)e);
        }
        for (String feature : features) {
            if (this.discoInfoManager.supportsFeature(contactAddress, feature)) continue;
            return false;
        }
        return true;
    }

    public boolean checkFeatureSupport(String node, String subnode, String[] features) {
        try {
            logger.info((Object)("Discovering info for: " + node + " subnode: " + subnode));
            DiscoverInfo info = this.discoInfoManager.discoverInfo(node, subnode);
            logger.info((Object)"Features");
            Iterator featuresList = info.getFeatures();
            while (featuresList.hasNext()) {
                DiscoverInfo.Feature f = (DiscoverInfo.Feature)featuresList.next();
                logger.info((Object)f.toXML());
            }
            logger.info((Object)"Identities");
            Iterator identities = info.getIdentities();
            while (identities.hasNext()) {
                DiscoverInfo.Identity identity = (DiscoverInfo.Identity)identities.next();
                logger.info((Object)identity.toXML());
            }
        }
        catch (XMPPException e) {
            logger.error((Object)e, (Throwable)e);
        }
        for (String feature : features) {
            if (this.discoInfoManager.supportsFeature(node, feature)) continue;
            return false;
        }
        return true;
    }

    public List<String> discoverItems(String node) throws XMPPException {
        DiscoverItems itemsDisco = this.discoInfoManager.discoverItems(node);
        logger.info((Object)("HAVE Discovered items for: " + node));
        ArrayList<String> result = new ArrayList<String>();
        Iterator items = itemsDisco.getItems();
        while (items.hasNext()) {
            DiscoverItems.Item item = (DiscoverItems.Item)items.next();
            logger.info((Object)item.toXML());
            if (item.getNode() != null && item.getEntityID().equals(node)) {
                result.add(item.getNode());
                continue;
            }
            result.add(item.getEntityID());
        }
        return result;
    }

    class XmppConnectionAdapter
    implements XmppConnection {
        private final XMPPConnection connection;

        XmppConnectionAdapter(XMPPConnection connection) {
            this.connection = connection;
        }

        public void sendPacket(Packet packet) {
            this.connection.sendPacket(packet);
        }

        public Packet sendPacketAndGetReply(Packet packet) {
            PacketCollector packetCollector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(packet.getPacketID()));
            this.connection.sendPacket(packet);
            Packet response = packetCollector.nextResult(20000L);
            packetCollector.cancel();
            return response;
        }
    }
}

