/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.protocol.xmpp;

import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.JingleIQ;
import net.java.sip.communicator.util.Logger;
import org.jitsi.impl.protocol.xmpp.XmppProtocolProvider;
import org.jitsi.protocol.xmpp.AbstractOperationSetJingle;
import org.jitsi.protocol.xmpp.XmppConnection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;

class OperationSetJingleImpl
extends AbstractOperationSetJingle
implements PacketFilter,
PacketListener {
    private static final Logger logger = Logger.getLogger(OperationSetJingleImpl.class);
    private final XmppProtocolProvider xmppProvider;

    OperationSetJingleImpl(XmppProtocolProvider xmppProvider) {
        this.xmppProvider = xmppProvider;
    }

    public void initialize() {
        this.xmppProvider.getConnection().addPacketListener((PacketListener)this, (PacketFilter)this);
    }

    protected String getOurJID() {
        return this.xmppProvider.getOurJid();
    }

    protected XmppConnection getConnection() {
        return this.xmppProvider.getConnectionAdapter();
    }

    public boolean accept(Packet packet) {
        try {
            if (!(packet instanceof JingleIQ)) {
                String packetID = packet.getPacketID();
                XMPPError error = packet.getError();
                if (error != null) {
                    String errorMessage = error.getMessage();
                    logger.error((Object)("Received an error: code=" + error.getCode() + " message=" + errorMessage));
                }
            }
            return packet instanceof JingleIQ && this.getSession(((JingleIQ)packet).getSID()) != null;
        }
        catch (Throwable t) {
            logger.error((Object)t, t);
            return false;
        }
    }

    public void processPacket(Packet packet) {
        block5: {
            IQ iq = (IQ)packet;
            if (iq.getType() == IQ.Type.SET) {
                IQ ack = IQ.createResultIQ((IQ)iq);
                this.getConnection().sendPacket((Packet)ack);
            }
            try {
                if (iq instanceof JingleIQ) {
                    this.processJingleIQ((JingleIQ)iq);
                }
            }
            catch (Throwable t) {
                if (logger.isInfoEnabled()) {
                    String packetClass = iq instanceof JingleIQ ? "Jingle" : packet.getClass().getSimpleName();
                    logger.info((Object)("Error while handling incoming " + packetClass + " packet: "), t);
                }
                if (!(t instanceof ThreadDeath)) break block5;
                throw (ThreadDeath)t;
            }
        }
    }
}

