/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.thumbnail;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.Sha1Crypto;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ThumbnailElement {
    private static final Logger logger = Logger.getLogger(ThumbnailElement.class);
    public static final String ELEMENT_NAME = "thumbnail";
    public static final String NAMESPACE = "urn:xmpp:thumbs:0";
    public static final String CID = "cid";
    public static final String MIME_TYPE = "mime-type";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    private String cid;
    private String mimeType;
    private int width;
    private int height;

    public ThumbnailElement(String serverAddress, byte[] thumbnailData, String mimeType, int width, int height) {
        this.cid = this.createCid(serverAddress, thumbnailData);
        this.mimeType = mimeType;
        this.width = width;
        this.height = height;
    }

    public ThumbnailElement(String xml) {
        block9: {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
                Document doc = builder.parse(in);
                Element e = doc.getDocumentElement();
                String elementName = e.getNodeName();
                if (elementName.equals(ELEMENT_NAME)) {
                    this.setCid(e.getAttribute(CID));
                    this.setMimeType(e.getAttribute(MIME_TYPE));
                    this.setHeight(Integer.parseInt(e.getAttribute(HEIGHT)));
                    this.setHeight(Integer.parseInt(e.getAttribute(WIDTH)));
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Element name unknown!");
                }
            }
            catch (ParserConfigurationException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem parsing Thumbnail Element : " + xml), (Throwable)ex);
                }
            }
            catch (IOException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem parsing Thumbnail Element : " + xml), (Throwable)ex);
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block9;
                logger.debug((Object)("Problem parsing Thumbnail Element : " + xml), (Throwable)ex);
            }
        }
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\"");
        buf = this.addXmlAttribute(buf, CID, this.getCid());
        buf = this.addXmlAttribute(buf, MIME_TYPE, this.getMimeType());
        buf = this.addXmlIntAttribute(buf, WIDTH, this.getWidth());
        buf = this.addXmlIntAttribute(buf, HEIGHT, this.getWidth());
        buf.append("/>");
        return buf.toString();
    }

    public String getCid() {
        return this.cid;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    private StringBuffer addXmlAttribute(StringBuffer buff, String attrName, String attrValue) {
        buff.append(" " + attrName + "=\"").append(attrValue).append("\"");
        return buff;
    }

    private StringBuffer addXmlIntAttribute(StringBuffer buff, String attrName, int attrValue) {
        return this.addXmlAttribute(buff, attrName, String.valueOf(attrValue));
    }

    private String createCid(String serverAddress, byte[] thumbnailData) {
        block4: {
            try {
                return "sha1+" + Sha1Crypto.encode((byte[])thumbnailData) + "@" + serverAddress;
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Failed to encode the thumbnail in SHA-1.", (Throwable)e);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug((Object)"Failed to encode the thumbnail in SHA-1.", (Throwable)e);
            }
        }
        return null;
    }
}

