/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.operation.AbstractMutatingCacheOperation;
import com.hazelcast.cache.impl.operation.CacheRemoveBackupOperation;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CacheRemoveOperation
extends AbstractMutatingCacheOperation {
    private Data oldValue;

    public CacheRemoveOperation() {
    }

    public CacheRemoveOperation(String name, Data key, Data oldValue) {
        this(name, key, oldValue, -1);
    }

    public CacheRemoveOperation(String name, Data key, Data oldValue, int completionId) {
        super(name, key, completionId);
        this.oldValue = oldValue;
    }

    @Override
    public void run() throws Exception {
        this.response = this.oldValue == null ? Boolean.valueOf(this.cache.remove(this.key, this.getCallerUuid())) : Boolean.valueOf(this.cache.remove(this.key, this.oldValue, this.getCallerUuid()));
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public Operation getBackupOperation() {
        return new CacheRemoveBackupOperation(this.name, this.key);
    }

    @Override
    public int getId() {
        return 5;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        IOUtil.writeNullableData(out, this.oldValue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.oldValue = IOUtil.readNullableData(in);
    }
}

