/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.MigratableHandler;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.logging.Level;

public abstract class AbstractSelectionHandler
implements MigratableHandler {
    protected final ILogger logger;
    protected final SocketChannelWrapper socketChannel;
    protected final TcpIpConnection connection;
    protected final TcpIpConnectionManager connectionManager;
    protected Selector selector;
    protected IOSelector ioSelector;
    private SelectionKey selectionKey;
    private final int initialOps;

    public AbstractSelectionHandler(TcpIpConnection connection, IOSelector ioSelector, int initialOps) {
        this.connection = connection;
        this.ioSelector = ioSelector;
        this.selector = ioSelector.getSelector();
        this.socketChannel = connection.getSocketChannelWrapper();
        this.connectionManager = connection.getConnectionManager();
        this.logger = this.connectionManager.ioService.getLogger(this.getClass().getName());
        this.initialOps = initialOps;
    }

    protected SelectionKey getSelectionKey() {
        if (this.selectionKey == null) {
            try {
                this.selectionKey = this.socketChannel.register(this.selector, this.initialOps, this);
            }
            catch (ClosedChannelException e) {
                this.handleSocketException(e);
            }
        }
        return this.selectionKey;
    }

    final void handleSocketException(Throwable e) {
        Level level;
        if (e instanceof OutOfMemoryError) {
            this.connectionManager.ioService.onOutOfMemory((OutOfMemoryError)e);
        }
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
        this.connection.close(e);
        ConnectionType connectionType = this.connection.getType();
        if (connectionType.isClient() && !connectionType.isBinary()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.currentThread().getName());
        sb.append(" Closing socket to endpoint ");
        sb.append(this.connection.getEndPoint());
        sb.append(", Cause:").append(e);
        Level level2 = level = this.connectionManager.ioService.isActive() ? Level.WARNING : Level.FINEST;
        if (e instanceof IOException) {
            this.logger.log(level, sb.toString());
        } else {
            this.logger.log(level, sb.toString(), e);
        }
    }

    final void registerOp(int operation) {
        SelectionKey selectionKey = this.getSelectionKey();
        try {
            selectionKey.interestOps(selectionKey.interestOps() | operation);
        }
        catch (Throwable e) {
            this.handleSocketException(e);
        }
    }

    final void unregisterOp(int operation) {
        SelectionKey selectionKey = this.getSelectionKey();
        try {
            selectionKey.interestOps(selectionKey.interestOps() & ~operation);
        }
        catch (Throwable e) {
            this.handleSocketException(e);
        }
    }

    @Override
    public IOSelector getOwner() {
        return this.ioSelector;
    }

    void startMigration(final IOSelector newOwner) {
        assert (this.ioSelector == Thread.currentThread()) : "startMigration can only run on the owning IOSelector thread";
        assert (this.ioSelector != newOwner) : "newOwner can't be the same as the existing owner";
        if (!this.socketChannel.isOpen()) {
            return;
        }
        this.unregisterOp(this.initialOps);
        this.ioSelector = newOwner;
        this.selectionKey.cancel();
        this.selectionKey = null;
        this.selector = null;
        newOwner.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                AbstractSelectionHandler.this.completeMigration(newOwner);
            }
        });
    }

    private void completeMigration(IOSelector newOwner) {
        assert (this.ioSelector == newOwner);
        if (!this.socketChannel.isOpen()) {
            return;
        }
        this.selector = newOwner.getSelector();
        this.selectionKey = this.getSelectionKey();
        this.registerOp(this.initialOps);
    }
}

