/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.InternalPartitionLostEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.PartitionAwareService;
import java.util.Map;

class MapPartitionAwareService
implements PartitionAwareService {
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;

    public MapPartitionAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public void onPartitionLost(InternalPartitionLostEvent partitionLostEvent) {
        Address thisAddress = this.nodeEngine.getThisAddress();
        int partitionId = partitionLostEvent.getPartitionId();
        for (Map.Entry<String, MapContainer> entry : this.mapServiceContext.getMapContainers().entrySet()) {
            String mapName = entry.getKey();
            MapContainer mapContainer = entry.getValue();
            if (mapContainer.getBackupCount() > partitionLostEvent.getLostReplicaIndex()) continue;
            this.mapServiceContext.getMapEventPublisher().publishMapPartitionLostEvent(thisAddress, mapName, partitionId);
        }
    }
}

