/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationexecutor.classic;

import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.impl.operationexecutor.OperationHostileThread;
import com.hazelcast.spi.impl.operationexecutor.ResponsePacketHandler;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public final class ResponseThread
extends Thread
implements OperationHostileThread {
    final BlockingQueue<Packet> workQueue = new LinkedBlockingQueue<Packet>();
    volatile long processedResponses;
    private final ILogger logger;
    private final ResponsePacketHandler responsePacketHandler;
    private volatile boolean shutdown;

    public ResponseThread(HazelcastThreadGroup threadGroup, ILogger logger, ResponsePacketHandler responsePacketHandler) {
        super(threadGroup.getInternalThreadGroup(), threadGroup.getThreadNamePrefix("response"));
        this.setContextClassLoader(threadGroup.getClassLoader());
        this.logger = logger;
        this.responsePacketHandler = responsePacketHandler;
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Throwable t) {
            OutOfMemoryErrorDispatcher.inspectOutputMemoryError(t);
            this.logger.severe(t);
        }
    }

    private void doRun() {
        while (true) {
            Packet responsePacket;
            try {
                responsePacket = this.workQueue.take();
            }
            catch (InterruptedException e) {
                if (!this.shutdown) continue;
                return;
            }
            if (this.shutdown) {
                return;
            }
            this.process(responsePacket);
        }
    }

    @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    private void process(Packet responsePacket) {
        ++this.processedResponses;
        try {
            this.responsePacketHandler.handle(responsePacket);
        }
        catch (Throwable e) {
            OutOfMemoryErrorDispatcher.inspectOutputMemoryError(e);
            this.logger.severe("Failed to process response: " + responsePacket + " on response thread:" + this.getName(), e);
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }
}

