/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;

public abstract class FamilyVersionsCmd
extends ConnCommand {
    private final SnacFamilyInfo[] families;

    protected FamilyVersionsCmd(int n, SnacPacket snacPacket) {
        super(n);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.families = new SnacFamilyInfo[byteBlock.getLength() / 4];
        for (int i = 0; i < this.families.length; ++i) {
            int n2 = BinaryTools.getUShort(byteBlock, i * 4);
            int n3 = BinaryTools.getUShort(byteBlock, i * 4 + 2);
            this.families[i] = new SnacFamilyInfo(n2, n3);
        }
    }

    protected FamilyVersionsCmd(int n, SnacFamilyInfo[] snacFamilyInfoArray) {
        super(n);
        this.families = snacFamilyInfoArray == null ? null : (SnacFamilyInfo[])snacFamilyInfoArray.clone();
    }

    public final SnacFamilyInfo[] getSnacFamilyInfos() {
        return (SnacFamilyInfo[])this.families.clone();
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.families != null) {
            for (int i = 0; i < this.families.length; ++i) {
                BinaryTools.writeUShort(outputStream, this.families[i].getFamily());
                BinaryTools.writeUShort(outputStream, this.families[i].getVersion());
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MiscTools.getClassName(this) + ": family versions: ");
        if (this.families != null) {
            for (int i = 0; i < this.families.length; ++i) {
                stringBuffer.append(Integer.toHexString(this.families[i].getFamily()));
                stringBuffer.append(" (v=");
                stringBuffer.append(Integer.toHexString(this.families[i].getVersion()));
                stringBuffer.append("), ");
            }
        }
        return stringBuffer.toString();
    }
}

