/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.ByteBuffer;

public class Utilities {
    private Utilities() {
    }

    public static String pad(int padding) {
        if (padding > 0) {
            StringBuffer sb = new StringBuffer(padding);
            for (int i = 0; i < padding; ++i) {
                sb.append(' ');
            }
            return sb.toString();
        }
        return "";
    }

    public static String pad(String string, int minLength) {
        String result = string;
        int pad = minLength - string.length();
        if (pad > 0) {
            result = string + Utilities.pad(minLength - string.length());
        } else if (pad < 0) {
            result = string.substring(0, minLength);
        }
        return result;
    }

    public static String deleteChar(String fromString, char charToDelete) {
        StringBuffer buffer = new StringBuffer(fromString.length());
        for (int i = 0; i < fromString.length(); ++i) {
            if (fromString.charAt(i) == charToDelete) continue;
            buffer.append(fromString.charAt(i));
        }
        return new String(buffer);
    }

    public static void dump(PrintWriter pw, int padding, String string) {
        pw.print(Utilities.pad(padding));
        pw.println(string);
    }

    public static InputStream getInputStream(URL url) throws IOException {
        if (url.getProtocol().equals("file")) {
            return new FileInputStream(url.getFile());
        }
        return url.openStream();
    }

    public static void outString(DataOutputStream dos, String s) throws IOException {
        dos.writeShort((short)s.length());
        for (int i = 0; i < s.length(); ++i) {
            dos.writeChar(s.charAt(i));
        }
    }

    public static String getString(DataInputStream dis) throws IOException {
        int size = dis.readShort();
        char[] charBuffer = new char[size];
        for (int i = 0; i < size; ++i) {
            charBuffer[i] = dis.readChar();
        }
        return new String(charBuffer, 0, size);
    }

    public static String getString(ByteBuffer bb) throws IOException {
        int size = bb.getShort();
        char[] charBuffer = new char[size];
        for (int i = 0; i < size; ++i) {
            charBuffer[i] = bb.getChar();
        }
        return new String(charBuffer, 0, size);
    }

    public static String getProperty(String name, String defaultValue) {
        String value;
        try {
            value = System.getProperty(name, defaultValue);
        }
        catch (SecurityException se) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean getBoolean(String name) {
        boolean value;
        try {
            value = Boolean.getBoolean(name);
        }
        catch (SecurityException se) {
            value = false;
        }
        return value;
    }

    public static Long getLong(String name, long defaultValue) {
        Long value;
        try {
            value = Long.getLong(name, defaultValue);
        }
        catch (SecurityException se) {
            value = new Long(defaultValue);
        }
        return value;
    }

    public static Integer getInteger(String name, int defaultValue) {
        Integer value;
        try {
            value = Integer.getInteger(name, defaultValue);
        }
        catch (SecurityException se) {
            value = new Integer(defaultValue);
        }
        return value;
    }
}

