/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.protocol;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.PullSourceStream;
import org.jitsi.impl.neomedia.protocol.BufferStreamAdapter;

public class PullBufferStreamAdapter
extends BufferStreamAdapter<PullSourceStream>
implements PullBufferStream {
    public PullBufferStreamAdapter(PullSourceStream stream, Format format) {
        super(stream, format);
    }

    private static int getFrameSizeInBytes(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        int frameSizeInBits = audioFormat.getFrameSizeInBits();
        if (frameSizeInBits <= 0) {
            return audioFormat.getSampleSizeInBits() / 8 * audioFormat.getChannels();
        }
        return frameSizeInBits <= 8 ? 1 : frameSizeInBits / 8;
    }

    @Override
    public void read(Buffer buffer) throws IOException {
        Object data = buffer.getData();
        byte[] bytes = null;
        if (data != null) {
            if (data instanceof byte[]) {
                bytes = (byte[])data;
            } else if (data instanceof short[]) {
                short[] shorts = (short[])data;
                bytes = new byte[2 * shorts.length];
            } else if (data instanceof int[]) {
                int[] ints = (int[])data;
                bytes = new byte[4 * ints.length];
            }
        }
        if (bytes == null) {
            int frameSizeInBytes = PullBufferStreamAdapter.getFrameSizeInBytes(this.getFormat());
            bytes = new byte[1024 * (frameSizeInBytes <= 0 ? 4 : frameSizeInBytes)];
        }
        this.read(buffer, bytes, 0, bytes.length);
    }

    @Override
    protected int doRead(Buffer buffer, byte[] data, int offset, int length) throws IOException {
        return ((PullSourceStream)this.stream).read(data, offset, length);
    }

    @Override
    public boolean willReadBlock() {
        return ((PullSourceStream)this.stream).willReadBlock();
    }
}

