/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPSDES;

public class RTCPSDESPacket
extends RTCPPacket {
    public RTCPSDES[] sdes;

    public RTCPSDESPacket(RTCPPacket parent) {
        super(parent);
        this.type = 202;
    }

    public RTCPSDESPacket(RTCPSDES[] sdes) {
        if (sdes.length > 31) {
            throw new IllegalArgumentException("Too many SDESs");
        }
        this.sdes = sdes;
    }

    public void assemble(DataOutputStream out) throws IOException {
        out.writeByte(128 + this.sdes.length);
        out.writeByte(202);
        out.writeShort(this.calcLength() - 4 >> 2);
        for (int i = 0; i < this.sdes.length; ++i) {
            int j;
            out.writeInt(this.sdes[i].ssrc);
            int sublen = 0;
            for (j = 0; j < this.sdes[i].items.length; ++j) {
                out.writeByte(this.sdes[i].items[j].type);
                out.writeByte(this.sdes[i].items[j].data.length);
                out.write(this.sdes[i].items[j].data);
                sublen += 2 + this.sdes[i].items[j].data.length;
            }
            for (j = (sublen + 4 & 0xFFFFFFFC) - sublen; j > 0; --j) {
                out.writeByte(0);
            }
        }
    }

    public int calcLength() {
        int len = 4;
        for (int i = 0; i < this.sdes.length; ++i) {
            int sublen = 5;
            for (int j = 0; j < this.sdes[i].items.length; ++j) {
                sublen += 2 + this.sdes[i].items[j].data.length;
            }
            sublen = sublen + 3 & 0xFFFFFFFC;
            len += sublen;
        }
        return len;
    }

    public String toString() {
        return "\tRTCP SDES Packet:\n" + RTCPSDES.toString(this.sdes);
    }
}

