/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.bccontrib.digests;

import org.bouncycastle.crypto.ExtendedDigest;
import org.jitsi.bccontrib.engines.ThreefishCipher;
import org.jitsi.bccontrib.util.ByteLong;

public class Skein
implements ExtendedDigest {
    public static final int NORMAL = 0;
    public static final int ZEROED_STATE = 1;
    public static final int CHAINED_STATE = 2;
    public static final int CHAINED_CONFIG = 3;
    private final byte[] schema = new byte[]{83, 72, 65, 51};
    private ThreefishCipher cipher;
    private int cipherStateBits;
    private int cipherStateBytes;
    private int cipherStateWords;
    private int outputBytes;
    private byte[] inputBuffer;
    private int bytesFilled;
    private long[] cipherInput;
    private long[] state;
    private int hashSize;
    SkeinConfig configuration;
    public UbiTweak ubiParameters;

    public int getStateSize() {
        return this.cipherStateBits;
    }

    public Skein(int stateSize, int outputSize) throws IllegalArgumentException {
        this.setup(stateSize, outputSize);
        this.configuration = new SkeinConfig(this);
        this.configuration.setSchema(this.schema);
        this.configuration.setVersion(1);
        this.configuration.generateConfiguration();
        this.initialize();
    }

    public Skein(int stateSize, int outputSize, long treeInfo, byte[] key) throws IllegalArgumentException {
        this.setup(stateSize, outputSize);
        if (key.length > 0) {
            this.outputBytes = this.cipherStateBytes;
            this.ubiParameters.startNewBlockType(0L);
            this.update(key, 0, key.length);
            byte[] preHash = this.finalPad();
            for (int i = 0; i < this.cipherStateWords; ++i) {
                this.state[i] = ByteLong.GetUInt64(preHash, i * 8);
            }
        }
        this.outputBytes = (outputSize + 7) / 8;
        this.configuration = new SkeinConfig(this);
        this.configuration.setSchema(this.schema);
        this.configuration.setVersion(1);
        this.initialize(3);
    }

    private void setup(int stateSize, int outputSize) throws IllegalArgumentException {
        if (outputSize <= 0) {
            throw new IllegalArgumentException("Skein: Output bit size must be greater than zero.");
        }
        this.cipherStateBits = stateSize;
        this.cipherStateBytes = stateSize / 8;
        this.cipherStateWords = stateSize / 64;
        this.hashSize = outputSize;
        this.outputBytes = (outputSize + 7) / 8;
        this.cipher = ThreefishCipher.createCipher(stateSize);
        if (this.cipher == null) {
            throw new IllegalArgumentException("Skein: Unsupported state size.");
        }
        this.inputBuffer = new byte[this.cipherStateBytes];
        this.cipherInput = new long[this.cipherStateWords];
        this.state = new long[this.cipherStateWords];
        this.ubiParameters = new UbiTweak();
    }

    void ProcessBlock(int bytes) {
        this.cipher.setKey(this.state);
        this.ubiParameters.addBytesProcessed(bytes);
        this.cipher.setTweak(this.ubiParameters.getTweak());
        this.cipher.encrypt(this.cipherInput, this.state);
        for (int i = 0; i < this.cipherInput.length; ++i) {
            int n = i;
            this.state[n] = this.state[n] ^ this.cipherInput[i];
        }
    }

    public void updateBits(byte[] array, int start, int length) throws IllegalStateException {
        if (this.ubiParameters.isBitPad()) {
            throw new IllegalStateException("Skein: partial byte only on last data block");
        }
        if ((length & 7) == 0) {
            this.update(array, start, length >>> 3);
            return;
        }
        this.update(array, start, (length >>> 3) + 1);
        byte mask = (byte)(1 << 7 - (length & 7));
        this.inputBuffer[this.bytesFilled - 1] = (byte)(this.inputBuffer[this.bytesFilled - 1] & 0 - mask | mask);
        this.ubiParameters.setBitPad(true);
    }

    public void update(byte[] array, int start, int length) {
        for (int bytesDone = 0; bytesDone < length; ++bytesDone) {
            if (this.bytesFilled == this.cipherStateBytes) {
                this.InputBufferToCipherInput();
                this.ProcessBlock(this.cipherStateBytes);
                this.ubiParameters.setFirstBlock(false);
                this.bytesFilled = 0;
            }
            this.inputBuffer[this.bytesFilled++] = array[start++];
        }
    }

    public byte[] doFinal() {
        int j;
        int i;
        for (i = this.bytesFilled; i < this.inputBuffer.length; ++i) {
            this.inputBuffer[i] = 0;
        }
        this.InputBufferToCipherInput();
        this.ubiParameters.setFinalBlock(true);
        this.ProcessBlock(this.bytesFilled);
        for (i = 0; i < this.cipherInput.length; ++i) {
            this.cipherInput[i] = 0L;
        }
        byte[] hash = new byte[this.outputBytes];
        long[] oldState = new long[this.cipherStateWords];
        for (j = 0; j < this.state.length; ++j) {
            oldState[j] = this.state[j];
        }
        for (i = 0; i < this.outputBytes; i += this.cipherStateBytes) {
            this.ubiParameters.startNewBlockType(63L);
            this.ubiParameters.setFinalBlock(true);
            this.ProcessBlock(8);
            int outputSize = this.outputBytes - i;
            if (outputSize > this.cipherStateBytes) {
                outputSize = this.cipherStateBytes;
            }
            ByteLong.PutBytes(this.state, hash, i, outputSize);
            for (j = 0; j < this.state.length; ++j) {
                this.state[j] = oldState[j];
            }
            this.cipherInput[0] = this.cipherInput[0] + 1L;
        }
        this.reset();
        return hash;
    }

    private byte[] finalPad() {
        int i;
        for (i = this.bytesFilled; i < this.inputBuffer.length; ++i) {
            this.inputBuffer[i] = 0;
        }
        this.InputBufferToCipherInput();
        this.ubiParameters.setFinalBlock(true);
        this.ProcessBlock(this.bytesFilled);
        byte[] data = new byte[this.outputBytes];
        for (i = 0; i < this.outputBytes; i += this.cipherStateBytes) {
            int outputSize = this.outputBytes - i;
            if (outputSize > this.cipherStateBytes) {
                outputSize = this.cipherStateBytes;
            }
            ByteLong.PutBytes(this.state, data, i, outputSize);
        }
        return data;
    }

    private void initialize(int initializationType) {
        switch (initializationType) {
            case 0: {
                this.initialize();
                return;
            }
            case 1: {
                for (int i = 0; i < this.state.length; ++i) {
                    this.state[i] = 0L;
                }
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.configuration.generateConfiguration(this.state);
                this.initialize();
                return;
            }
        }
        this.bytesFilled = 0;
    }

    private final void initialize() {
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = this.configuration.ConfigValue[i];
        }
        this.ubiParameters.startNewBlockType(48L);
        this.bytesFilled = 0;
    }

    public final void initialize(long[] externalState) {
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = externalState[i];
        }
        this.ubiParameters.startNewBlockType(48L);
        this.bytesFilled = 0;
    }

    void InputBufferToCipherInput() {
        for (int i = 0; i < this.cipherStateWords; ++i) {
            this.cipherInput[i] = ByteLong.GetUInt64(this.inputBuffer, i * 8);
        }
    }

    public int getcipherStateBits() {
        return this.cipherStateBits;
    }

    public int getHashSize() {
        return this.hashSize;
    }

    public String getAlgorithmName() {
        return "Skein" + this.cipherStateBits;
    }

    public int getDigestSize() {
        return this.outputBytes;
    }

    public void update(byte in) {
        byte[] tmp = new byte[1];
        this.update(tmp, 0, 1);
    }

    public int doFinal(byte[] out, int outOff) {
        byte[] hash = this.doFinal();
        System.arraycopy(hash, 0, out, outOff, hash.length);
        return hash.length;
    }

    public void reset() {
        this.initialize();
    }

    public int getByteLength() {
        return this.cipherStateBytes;
    }

    public long[] getState() {
        long[] s = new long[this.state.length];
        for (int i = 0; i < this.state.length; ++i) {
            s[i] = this.state[i];
        }
        return s;
    }

    class UbiTweak {
        static final long Key = 0L;
        static final long Config = 4L;
        static final long Personalization = 8L;
        static final long PublicKey = 12L;
        static final long KeyIdentifier = 16L;
        static final long Nonce = 20L;
        static final long Message = 48L;
        static final long Out = 63L;
        private static final long T1FlagFinal = Long.MIN_VALUE;
        private static final long T1FlagFirst = 0x4000000000000000L;
        private static final long T1FlagBitPad = 0x80000000000000L;
        private long[] tweak = new long[2];

        UbiTweak() {
        }

        boolean isFirstBlock() {
            return (this.tweak[1] & 0x4000000000000000L) != 0L;
        }

        void setFirstBlock(boolean value) {
            this.tweak[1] = value ? this.tweak[1] | 0x4000000000000000L : this.tweak[1] & 0xBFFFFFFFFFFFFFFFL;
        }

        boolean isFinalBlock() {
            return (this.tweak[1] & Long.MIN_VALUE) != 0L;
        }

        void setFinalBlock(boolean value) {
            this.tweak[1] = value ? this.tweak[1] | Long.MIN_VALUE : this.tweak[1] & Long.MAX_VALUE;
        }

        boolean isBitPad() {
            return (this.tweak[1] & 0x80000000000000L) != 0L;
        }

        void setBitPad(boolean value) {
            this.tweak[1] = value ? this.tweak[1] | 0x80000000000000L : this.tweak[1] & 0xFF7FFFFFFFFFFFFFL;
        }

        byte getTreeLevel() {
            return (byte)(this.tweak[1] >> 48 & 0x7FL);
        }

        void setTreeLevel(int value) throws Exception {
            if (value > 63) {
                throw new Exception("Tree level must be between 0 and 63, inclusive.");
            }
            this.tweak[1] = this.tweak[1] & 0xFF80FFFFFFFFFFFFL;
            this.tweak[1] = this.tweak[1] | (long)value << 48;
        }

        long[] getBitsProcessed() {
            long[] retval = new long[]{this.tweak[0], this.tweak[1] & 0xFFFFFFFFL};
            return retval;
        }

        void setBitsProcessed(long value) {
            this.tweak[0] = value;
            this.tweak[1] = this.tweak[1] & 0xFFFFFFFF00000000L;
        }

        void addBytesProcessed(int value) {
            int len = 3;
            long carry = value;
            long[] words = new long[]{this.tweak[0] & 0xFFFFFFFFL, this.tweak[0] >>> 32 & 0xFFFFFFFFL, this.tweak[1] & 0xFFFFFFFFL};
            for (int i = 0; i < 3; ++i) {
                words[i] = carry += words[i];
                carry >>= 32;
            }
            this.tweak[0] = words[0] & 0xFFFFFFFFL;
            this.tweak[0] = this.tweak[0] | (words[1] & 0xFFFFFFFFL) << 32;
            this.tweak[1] = this.tweak[1] | words[2] & 0xFFFFFFFFL;
        }

        long getBlockType() {
            return this.tweak[1] >> 56 & 0x3FL;
        }

        void setBlockType(long value) {
            this.tweak[1] = value << 56;
        }

        void startNewBlockType(long type) {
            this.setBitsProcessed(0L);
            this.setBlockType(type);
            this.setFirstBlock(true);
        }

        long[] getTweak() {
            return this.tweak;
        }

        void setTweak(long[] tweak) {
            this.tweak = tweak;
        }
    }

    class SkeinConfig {
        private final int stateSize;
        long[] ConfigValue;
        long[] ConfigString;

        SkeinConfig(Skein sourceHash) {
            this.stateSize = sourceHash.getcipherStateBits();
            this.ConfigValue = new long[this.stateSize / 64];
            this.ConfigString = new long[this.ConfigValue.length];
            this.ConfigString[1] = sourceHash.getHashSize();
        }

        void generateConfiguration() {
            ThreefishCipher cipher = ThreefishCipher.createCipher(this.stateSize);
            UbiTweak tweak = new UbiTweak();
            tweak.startNewBlockType(4L);
            tweak.setFinalBlock(true);
            tweak.setBitsProcessed(32L);
            cipher.setTweak(tweak.getTweak());
            cipher.encrypt(this.ConfigString, this.ConfigValue);
            this.ConfigValue[0] = this.ConfigValue[0] ^ this.ConfigString[0];
            this.ConfigValue[1] = this.ConfigValue[1] ^ this.ConfigString[1];
            this.ConfigValue[2] = this.ConfigValue[2] ^ this.ConfigString[2];
        }

        void generateConfiguration(long[] initialState) {
            ThreefishCipher cipher = ThreefishCipher.createCipher(this.stateSize);
            UbiTweak tweak = new UbiTweak();
            tweak.startNewBlockType(4L);
            tweak.setFinalBlock(true);
            tweak.setBitsProcessed(32L);
            cipher.setKey(initialState);
            cipher.setTweak(tweak.getTweak());
            cipher.encrypt(this.ConfigString, this.ConfigValue);
            this.ConfigValue[0] = this.ConfigValue[0] ^ this.ConfigString[0];
            this.ConfigValue[1] = this.ConfigValue[1] ^ this.ConfigString[1];
            this.ConfigValue[2] = this.ConfigValue[2] ^ this.ConfigString[2];
        }

        void setSchema(byte[] schema) throws IllegalArgumentException {
            if (schema.length != 4) {
                throw new IllegalArgumentException("Skein configuration: Schema must be 4 bytes.");
            }
            long n = this.ConfigString[0];
            n &= 0xFFFFFFFF00000000L;
            n |= (long)schema[3] << 24;
            n |= (long)schema[2] << 16;
            n |= (long)schema[1] << 8;
            this.ConfigString[0] = n |= (long)schema[0];
        }

        void setVersion(int version) throws IllegalArgumentException {
            if (version < 0 || version > 3) {
                throw new IllegalArgumentException("Skein configuration: Version must be between 0 and 3, inclusive.");
            }
            this.ConfigString[0] = this.ConfigString[0] & 0xFFFFFFFCFFFFFFFFL;
            this.ConfigString[0] = this.ConfigString[0] | (long)version << 32;
        }

        void setTreeLeafSize(byte size) {
            this.ConfigString[2] = this.ConfigString[2] & 0xFFFFFFFFFFFFFF00L;
            this.ConfigString[2] = this.ConfigString[2] | (long)size;
        }

        void setTreeFanOutSize(byte size) {
            this.ConfigString[2] = this.ConfigString[2] & 0xFFFFFFFFFFFF00FFL;
            this.ConfigString[2] = this.ConfigString[2] | (long)size << 8;
        }

        void setMaxTreeHeight(byte height) throws IllegalArgumentException {
            if (height == 1) {
                throw new IllegalArgumentException("Skein configuration: Tree height must be zero or greater than 1.");
            }
            this.ConfigString[2] = this.ConfigString[2] & 0xFFFFFFFFFF00FFFFL;
            this.ConfigString[2] = this.ConfigString[2] | (long)height << 16;
        }
    }
}

