/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.fmj.ui.objeditor.ComponentValidationException;
import net.sf.fmj.ui.objeditor.ComponentValidator;
import net.sf.fmj.ui.objeditor.ObjEditor;
import net.sf.fmj.ui.objeditor.ObjEditorOKCancelDialog;
import net.sf.fmj.ui.utils.ErrorDialog;

public class RTPReceivePanel
extends JPanel
implements ObjEditor {
    private String url;
    private JComboBox comboTTL;
    private JLabel labelAddress;
    private JLabel labelPort;
    private JLabel labelTTL;
    private JTextField textAddress;
    private JTextField textPort;

    public static String run(Frame frame) {
        RTPReceivePanel rTPReceivePanel = new RTPReceivePanel();
        return (String)ObjEditorOKCancelDialog.run(frame, rTPReceivePanel, "", "Open RTP Session");
    }

    public RTPReceivePanel() {
        this.initComponents();
    }

    public Component getComponent() {
        return this;
    }

    public Object getObject() {
        return this.url;
    }

    public String getUrl() {
        return this.url;
    }

    private void initComponents() {
        this.labelAddress = new JLabel();
        this.textAddress = new JTextField();
        this.labelPort = new JLabel();
        this.textPort = new JTextField();
        this.labelTTL = new JLabel();
        this.comboTTL = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.labelAddress.setText("Address:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelAddress, gridBagConstraints);
        this.textAddress.setPreferredSize(new Dimension(80, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.textAddress, gridBagConstraints);
        this.labelPort.setText("Port:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelPort, gridBagConstraints);
        this.textPort.setPreferredSize(new Dimension(40, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.textPort, gridBagConstraints);
        this.labelTTL.setText("TTL:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.labelTTL, gridBagConstraints);
        this.comboTTL.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "8", "16", "32", "64", "128", "255"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.comboTTL, gridBagConstraints);
    }

    public void setObjectAndUpdateControl(Object object) {
        this.url = (String)object;
    }

    public boolean validateAndUpdateObj() {
        this.url = null;
        ComponentValidator componentValidator = new ComponentValidator();
        try {
            componentValidator.validateNotEmpty(this.textAddress, this.labelAddress);
            componentValidator.validateNotEmpty(this.textPort, this.labelPort);
            componentValidator.validateInteger(this.textPort, this.labelPort);
            componentValidator.validateNotEmpty(this.comboTTL, this.labelTTL);
            componentValidator.validateInteger(this.comboTTL, this.labelTTL);
        }
        catch (ComponentValidationException componentValidationException) {
            ErrorDialog.showError((Component)this, componentValidationException.getMessage());
            return false;
        }
        String string = this.textAddress.getText();
        int n = Integer.parseInt(this.textPort.getText());
        int n2 = Integer.parseInt((String)this.comboTTL.getSelectedItem());
        this.url = "rtp://" + string + ":" + n;
        return true;
    }
}

