/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.registry;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.fmj.registry.RegistryContents;
import net.sf.fmj.registry.RegistryIO;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.SerializationUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLRegistryIO
implements RegistryIO {
    private static final Logger logger = LoggerSingleton.logger;
    private final RegistryContents registryContents;
    private static final String version = "0.1";
    private static final String ELEMENT_REGISTRY = "registry";
    private static final String ATTR_VERSION = "version";
    private static final String ELEMENT_PROTO_PREFIX = "protocol-prefixes";
    private static final String ELEMENT_CONTENT_PREFIX = "content-prefixes";
    private static final String ELEMENT_PLUGINS = "plugins";
    private static final String ELEMENT_MIMETYPES = "mime-types";
    private static final String ELEMENT_MIMETYPE = "type";
    private static final String ELEMENT_CAPTURE_DEVICES = "capture-devices";
    private static final String ELEMENT_CODECS = "codecs";
    private static final String ELEMENT_DEMUXES = "demuxes";
    private static final String ELEMENT_MUXES = "muxes";
    private static final String ELEMENT_EFFECTS = "effects";
    private static final String ELEMENT_RENDERERS = "renderers";
    private static final String ELEMENT_PREFIX = "prefix";
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_DEVICE = "device";
    private static final String ELEMENT_DEVICE_NAME = "name";
    private static final String ELEMENT_DEVICE_LOCATOR = "locator";
    private static final String ELEMENT_DEVICE_FORMAT = "format";
    private static final String ELEMENT_DEVICE_FORMAT_CLASS = "class";
    private static final String ELEMENT_DEVICE_FORMAT_DESCRIPTION = "description";
    private static final String ELEMENT_DEVICE_FORMAT_SERIALIZED = "serialized";

    public XMLRegistryIO(RegistryContents registryContents) {
        this.registryContents = registryContents;
    }

    private Document buildDocument() throws IOException {
        Document document;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException();
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        Element element = document.createElement(ELEMENT_REGISTRY);
        element.setAttribute(ATTR_VERSION, version);
        document.appendChild(element);
        element.appendChild(this.getPluginsElement(document));
        element.appendChild(this.getContentElement(document));
        element.appendChild(this.getProtocolElement(document));
        element.appendChild(this.getMimeElement(document));
        element.appendChild(this.getCaptureDeviceElement(document));
        return document;
    }

    private Element getCaptureDeviceElement(Document document) throws IOException {
        Element element = document.createElement(ELEMENT_CAPTURE_DEVICES);
        for (CaptureDeviceInfo captureDeviceInfo : this.registryContents.captureDeviceInfoList) {
            if (captureDeviceInfo.getLocator() == null) continue;
            Element element2 = document.createElement(ELEMENT_DEVICE);
            Format[] formatArray = document.createElement(ELEMENT_DEVICE_NAME);
            formatArray.setTextContent(captureDeviceInfo.getName());
            element2.appendChild((Node)formatArray);
            formatArray = document.createElement(ELEMENT_DEVICE_LOCATOR);
            formatArray.setTextContent(captureDeviceInfo.getLocator().toExternalForm());
            element2.appendChild((Node)formatArray);
            formatArray = captureDeviceInfo.getFormats();
            for (int i = 0; i < formatArray.length; ++i) {
                Element element3 = document.createElement(ELEMENT_DEVICE_FORMAT);
                Element element4 = document.createElement("class");
                element4.setTextContent(formatArray[i].getClass().getName());
                element3.appendChild(element4);
                element4 = document.createElement(ELEMENT_DEVICE_FORMAT_DESCRIPTION);
                element4.setTextContent(formatArray[i].toString());
                element3.appendChild(element4);
                element4 = document.createElement(ELEMENT_DEVICE_FORMAT_SERIALIZED);
                element4.setTextContent(SerializationUtils.serialize(formatArray[i]));
                element3.appendChild(element4);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
        return element;
    }

    private Element getChild(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(string)) continue;
            return (Element)node;
        }
        return null;
    }

    private List<Element> getChildren(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<Element> arrayList = new ArrayList<Element>(n);
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(string)) continue;
            arrayList.add((Element)node);
        }
        return arrayList;
    }

    private Element getCodecElement(Document document) {
        return this.getPluginElement(2, ELEMENT_CODECS, document);
    }

    private Element getContentElement(Document document) {
        Element element = document.createElement(ELEMENT_CONTENT_PREFIX);
        for (String string : this.registryContents.contentPrefixList) {
            Element element2 = document.createElement(ELEMENT_PREFIX);
            element2.setTextContent(string);
            element.appendChild(element2);
        }
        return element;
    }

    private Element getDemuxElement(Document document) {
        return this.getPluginElement(1, ELEMENT_DEMUXES, document);
    }

    private Element getEffectElement(Document document) {
        return this.getPluginElement(3, ELEMENT_EFFECTS, document);
    }

    private Element getMimeElement(Document document) {
        Element element = document.createElement(ELEMENT_MIMETYPES);
        for (String string : this.registryContents.mimeTable.getMimeTypes()) {
            List<String> list = this.registryContents.mimeTable.getExtensions(string);
            Element element2 = document.createElement(ELEMENT_MIMETYPE);
            element2.setAttribute("value", string);
            element2.setAttribute("default-ext", this.registryContents.mimeTable.getDefaultExtension(string));
            element.appendChild(element2);
            for (int i = 0; i < list.size(); ++i) {
                String string2 = list.get(i);
                Element element3 = document.createElement("ext");
                element3.setTextContent(string2);
                element2.appendChild(element3);
            }
        }
        return element;
    }

    private Element getMuxElement(Document document) {
        return this.getPluginElement(5, ELEMENT_MUXES, document);
    }

    private Element getPluginElement(int n, String string, Document document) {
        Element element = document.createElement(string);
        Vector<String> vector = this.registryContents.plugins[n - 1];
        if (vector != null) {
            for (String string2 : vector) {
                Element element2 = document.createElement("class");
                element2.setTextContent(string2);
                element.appendChild(element2);
            }
        }
        return element;
    }

    private Element getPluginsElement(Document document) {
        Element element = document.createElement(ELEMENT_PLUGINS);
        element.appendChild(this.getCodecElement(document));
        element.appendChild(this.getDemuxElement(document));
        element.appendChild(this.getEffectElement(document));
        element.appendChild(this.getMuxElement(document));
        element.appendChild(this.getRendererElement(document));
        return element;
    }

    private Element getProtocolElement(Document document) {
        Element element = document.createElement(ELEMENT_PROTO_PREFIX);
        for (String string : this.registryContents.protocolPrefixList) {
            Element element2 = document.createElement(ELEMENT_PREFIX);
            element2.setTextContent(string);
            element.appendChild(element2);
        }
        return element;
    }

    private Element getRendererElement(Document document) {
        return this.getPluginElement(4, ELEMENT_RENDERERS, document);
    }

    private String getTextTrim(Element element) {
        String string = element.getTextContent();
        return string == null ? null : string.trim();
    }

    @Override
    public void load(InputStream inputStream) throws IOException {
        Object object;
        Exception exception = null;
        try {
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            this.loadDocument((Document)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            exception = parserConfigurationException;
        }
        catch (SAXException sAXException) {
            exception = sAXException;
        }
        if (exception != null) {
            object = new IOException();
            ((Throwable)object).initCause(exception);
            throw object;
        }
    }

    private void loadCaptureDevices(Element element) throws IOException, ClassNotFoundException {
        this.registryContents.captureDeviceInfoList.clear();
        List<Element> list = this.getChildren(element, ELEMENT_DEVICE);
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = list.get(i);
            Element element3 = this.getChild(element2, ELEMENT_DEVICE_NAME);
            Element element4 = this.getChild(element2, ELEMENT_DEVICE_LOCATOR);
            List<Element> list2 = this.getChildren(element2, ELEMENT_DEVICE_FORMAT);
            Format[] formatArray = new Format[list2.size()];
            for (int j = 0; j < list2.size(); ++j) {
                Element element5 = list2.get(j);
                Element element6 = this.getChild(element5, ELEMENT_DEVICE_FORMAT_SERIALIZED);
                formatArray[j] = SerializationUtils.deserialize(this.getTextTrim(element6));
            }
            CaptureDeviceInfo captureDeviceInfo = new CaptureDeviceInfo(this.getTextTrim(element3), new MediaLocator(this.getTextTrim(element4)), formatArray);
            this.registryContents.captureDeviceInfoList.add(captureDeviceInfo);
        }
    }

    private void loadContentPrefixes(Element element) {
        this.registryContents.contentPrefixList.clear();
        List<Element> list = this.getChildren(element, ELEMENT_PREFIX);
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = list.get(i);
            this.registryContents.contentPrefixList.add(this.getTextTrim(element2));
        }
    }

    private void loadDocument(Document document) throws IOException {
        Element element = (Element)document.getFirstChild();
        String string = element.getAttribute(ATTR_VERSION);
        logger.info("FMJ registry document version " + string);
        Element element2 = this.getChild(element, ELEMENT_PLUGINS);
        this.loadPlugins(element2);
        Element element3 = this.getChild(element, ELEMENT_CONTENT_PREFIX);
        this.loadContentPrefixes(element3);
        Element element4 = this.getChild(element, ELEMENT_PROTO_PREFIX);
        this.loadProtocolPrefixes(element4);
        Element element5 = this.getChild(element, ELEMENT_MIMETYPES);
        this.loadMimeTypes(element5);
        Element element6 = this.getChild(element, ELEMENT_CAPTURE_DEVICES);
        try {
            this.loadCaptureDevices(element6);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getMessage());
        }
    }

    private void loadMimeTypes(Element element) {
        this.registryContents.mimeTable.clear();
        List<Element> list = this.getChildren(element, ELEMENT_MIMETYPE);
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = list.get(i);
            String string = element2.getAttribute("value");
            String string2 = element2.getAttribute("default-ext");
            List<Element> list2 = this.getChildren(element2, "ext");
            for (int j = 0; j < list2.size(); ++j) {
                Element element3 = list2.get(j);
                String string3 = element3.getTextContent();
                this.registryContents.mimeTable.addMimeType(string3, string);
            }
            this.registryContents.mimeTable.addMimeType(string2, string);
        }
    }

    private void loadPlugins(Element element) {
        Element element2 = this.getChild(element, ELEMENT_CODECS);
        this.loadPlugins(element2, 2);
        Element element3 = this.getChild(element, ELEMENT_EFFECTS);
        this.loadPlugins(element3, 3);
        Element element4 = this.getChild(element, ELEMENT_RENDERERS);
        this.loadPlugins(element4, 4);
        Element element5 = this.getChild(element, ELEMENT_MUXES);
        this.loadPlugins(element5, 5);
        Element element6 = this.getChild(element, ELEMENT_DEMUXES);
        this.loadPlugins(element6, 1);
    }

    private void loadPlugins(Element element, int n) {
        if (element == null) {
            return;
        }
        Vector<String> vector = this.registryContents.plugins[n - 1];
        for (Element element2 : this.getChildren(element, "class")) {
            String string = this.getTextTrim(element2);
            vector.add(string);
        }
    }

    private void loadProtocolPrefixes(Element element) {
        this.registryContents.protocolPrefixList.clear();
        for (Element element2 : this.getChildren(element, ELEMENT_PREFIX)) {
            this.registryContents.protocolPrefixList.add(this.getTextTrim(element2));
        }
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        Transformer transformer;
        Document document = this.buildDocument();
        DOMSource dOMSource = new DOMSource(document);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            IOException iOException = new IOException();
            iOException.initCause(transformerConfigurationException);
            throw iOException;
        }
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        }
        catch (Exception exception) {
            // empty catch block
        }
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.transform(dOMSource, new StreamResult(new OutputStreamWriter(outputStream, "UTF-8")));
        }
        catch (TransformerException transformerException) {
            IOException iOException = new IOException();
            iOException.initCause(transformerException);
            throw iOException;
        }
    }
}

