/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;

public class RTCPRRPacket
extends RTCPPacket {
    public int ssrc;
    public RTCPReportBlock[] reports;

    public RTCPRRPacket(int n, RTCPReportBlock[] rTCPReportBlockArray) {
        if (rTCPReportBlockArray.length > 31) {
            throw new IllegalArgumentException("Too many reports");
        }
        this.ssrc = n;
        this.reports = rTCPReportBlockArray;
    }

    RTCPRRPacket(RTCPPacket rTCPPacket) {
        super(rTCPPacket);
        this.type = 201;
    }

    public void assemble(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(128 + this.reports.length);
        dataOutputStream.writeByte(201);
        dataOutputStream.writeShort(1 + this.reports.length * 6);
        dataOutputStream.writeInt(this.ssrc);
        for (int i = 0; i < this.reports.length; ++i) {
            dataOutputStream.writeInt(this.reports[i].ssrc);
            dataOutputStream.writeInt((this.reports[i].packetslost & 0xFFFFFF) + (this.reports[i].fractionlost << 24));
            dataOutputStream.writeInt((int)this.reports[i].lastseq);
            dataOutputStream.writeInt(this.reports[i].jitter);
            dataOutputStream.writeInt((int)this.reports[i].lsr);
            dataOutputStream.writeInt((int)this.reports[i].dlsr);
        }
    }

    public int calcLength() {
        return 8 + this.reports.length * 24;
    }

    public String toString() {
        return "\tRTCP RR (receiver report) packet for sync source " + this.ssrc + ":\n" + RTCPReportBlock.toString(this.reports);
    }
}

