/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.datasink.rtp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.RTPManager;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionAddress;
import net.sf.fmj.media.AbstractDataSink;
import net.sf.fmj.media.datasink.rtp.ParsedRTPUrl;
import net.sf.fmj.media.datasink.rtp.ParsedRTPUrlElement;
import net.sf.fmj.media.datasink.rtp.RTPBonusFormatsMgr;
import net.sf.fmj.media.datasink.rtp.RTPUrlParser;
import net.sf.fmj.media.datasink.rtp.RTPUrlParserException;
import net.sf.fmj.utility.LoggerSingleton;

public class Handler
extends AbstractDataSink {
    private static final Logger logger = LoggerSingleton.logger;
    private PushBufferDataSource source;
    private RTPManager rtpManager;
    private SendStream[] streams;
    private ParsedRTPUrl parsedRTPUrl;

    public void close() {
        if (this.rtpManager != null) {
            this.rtpManager.dispose();
        }
        try {
            this.stop();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
        }
    }

    public String getContentType() {
        if (this.source != null) {
            return this.source.getContentType();
        }
        return null;
    }

    public Object getControl(String string) {
        logger.warning("TODO: getControl " + string);
        return null;
    }

    public Object[] getControls() {
        logger.warning("TODO: getControls");
        return new Object[0];
    }

    public void open() throws IOException, SecurityException {
        if (this.getOutputLocator() == null) {
            throw new IOException("Output locator not set");
        }
        try {
            this.parsedRTPUrl = RTPUrlParser.parse(this.getOutputLocator().toExternalForm());
        }
        catch (RTPUrlParserException rTPUrlParserException) {
            logger.log(Level.WARNING, "" + rTPUrlParserException, rTPUrlParserException);
            throw new IOException("" + rTPUrlParserException);
        }
        try {
            this.rtpManager = RTPManager.newInstance();
            this.rtpManager.initialize(new SessionAddress());
            RTPBonusFormatsMgr.addBonusFormats(this.rtpManager);
            int n = this.source.getStreams().length;
            this.streams = new SendStream[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                String string;
                Format format = this.source.getStreams()[i].getFormat();
                if (format instanceof AudioFormat) {
                    string = "audio";
                } else if (format instanceof VideoFormat) {
                    string = "video";
                } else {
                    logger.warning("Skipping unknown source stream format: " + format);
                    continue;
                }
                ParsedRTPUrlElement parsedRTPUrlElement = this.parsedRTPUrl.find(string);
                if (parsedRTPUrlElement == null) {
                    logger.fine("Skipping source stream format not specified in URL: " + format);
                    continue;
                }
                String string2 = parsedRTPUrlElement.host;
                InetAddress inetAddress = InetAddress.getByName(string2);
                int n3 = parsedRTPUrlElement.port;
                int n4 = parsedRTPUrlElement.ttl;
                SessionAddress sessionAddress = new SessionAddress(inetAddress, n3, n4);
                this.rtpManager.addTarget(sessionAddress);
                this.streams[i] = this.rtpManager.createSendStream(this.source, i);
                ++n2;
            }
            if (n2 <= 0) {
                throw new IOException("No streams selected to be used");
            }
            this.source.connect();
        }
        catch (InvalidSessionAddressException invalidSessionAddressException) {
            logger.log(Level.WARNING, "" + invalidSessionAddressException, invalidSessionAddressException);
            throw new IOException("" + invalidSessionAddressException);
        }
        catch (UnsupportedFormatException unsupportedFormatException) {
            logger.log(Level.WARNING, "" + unsupportedFormatException, unsupportedFormatException);
            throw new IOException("" + unsupportedFormatException);
        }
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        logger.finer("setSource: " + dataSource);
        if (!(dataSource instanceof PushBufferDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PushBufferDataSource)dataSource;
    }

    public void start() throws IOException {
        this.source.start();
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] == null) continue;
            this.streams[i].start();
        }
    }

    public void stop() throws IOException {
        if (this.source != null) {
            this.source.stop();
        }
        if (this.streams != null) {
            for (int i = 0; i < this.streams.length; ++i) {
                if (this.streams[i] == null) continue;
                this.streams[i].stop();
            }
        }
    }
}

