/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeTable {
    private final Hashtable<String, String> hashTable = new Hashtable();
    private static final Hashtable<String, String> reverseHashTable = new Hashtable();

    public boolean addMimeType(String string, String string2) {
        this.hashTable.put(string, string2);
        reverseHashTable.put(string2, string);
        return true;
    }

    public void clear() {
        this.hashTable.clear();
        reverseHashTable.clear();
    }

    public String getDefaultExtension(String string) {
        return reverseHashTable.get(string);
    }

    public List<String> getExtensions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.hashTable.keySet()) {
            if (!this.hashTable.get(string2).equals(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public Hashtable<String, String> getMimeTable() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.putAll(this.hashTable);
        return hashtable;
    }

    public String getMimeType(String string) {
        return this.hashTable.get(string);
    }

    public Set<String> getMimeTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<String> iterator = this.hashTable.values().iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    public boolean removeMimeType(String string) {
        if (this.hashTable.get(string) == null) {
            return false;
        }
        reverseHashTable.remove(this.hashTable.get(string));
        this.hashTable.remove(string);
        return true;
    }
}

