/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controlpanel;

import javax.media.ControllerEvent;
import javax.media.EndOfMediaEvent;
import javax.media.Player;
import javax.media.Time;
import javax.swing.AbstractButton;
import net.sf.fmj.ejmf.toolkit.gui.controlpanel.AbstractControls;
import net.sf.fmj.ejmf.toolkit.gui.controls.AbstractListenerControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;
import net.sf.fmj.ejmf.toolkit.gui.controls.StandardFastForwardControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.StandardGainControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.StandardGainMeterControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.StandardPauseControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.StandardProgressControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.StandardReverseControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.StandardStartControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.StandardStopControl;

class StandardControls
extends AbstractControls {
    public static final String START_CONTROL = "StandardStartControl";
    public static final String PAUSE_CONTROL = "StandardPauseControl";
    public static final String FF_CONTROL = "StandardFastForwardControl";
    public static final String PROGRESS_CONTROL = "StandardProgressControl";
    public static final String REVERSE_CONTROL = "StandardReverseControl";
    public static final String STOP_CONTROL = "StandardStopControl";
    public static final String GAIN_CONTROL = "StandardGainControl";
    public static final String GAINMETER_CONTROL = "StandardGainMeterControl";
    private AbstractListenerControl startControl;
    private AbstractListenerControl stopControl;
    private AbstractListenerControl pauseControl;
    private AbstractListenerControl fastForwardControl;
    private AbstractListenerControl reverseControl;
    private AbstractListenerControl gainControl;
    private AbstractListenerControl gainMeterControl;
    private StandardProgressControl progressControl;
    private float fastForwardRate = 2.0f;

    public StandardControls(Skin skin, Player player) {
        super(skin, player);
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof EndOfMediaEvent) {
            this.getPlayer().setMediaTime(new Time(0L));
        }
        super.controllerUpdate(controllerEvent);
    }

    protected final AbstractListenerControl createFastForwardControl(Skin skin) {
        return new StandardFastForwardControl(skin);
    }

    protected final AbstractListenerControl createGainControl(Skin skin) {
        return new StandardGainControl(skin);
    }

    protected final AbstractListenerControl createGainMeterControl(Skin skin) {
        return new StandardGainMeterControl(skin);
    }

    protected final AbstractListenerControl createPauseControl(Skin skin) {
        return new StandardPauseControl(skin);
    }

    protected final StandardProgressControl createProgressControl(Skin skin) {
        return new StandardProgressControl(skin);
    }

    protected final AbstractListenerControl createReverseControl(Skin skin) {
        return new StandardReverseControl(skin);
    }

    protected final AbstractListenerControl createStartControl(Skin skin) {
        return new StandardStartControl(skin);
    }

    protected final AbstractListenerControl createStopControl(Skin skin) {
        return new StandardStopControl(skin);
    }

    public AbstractListenerControl getFastForwardControl() {
        return this.getControl(FF_CONTROL);
    }

    public AbstractListenerControl getGainControl() {
        return this.getControl(GAIN_CONTROL);
    }

    public AbstractListenerControl getGainMeterControl() {
        return this.getControl(GAINMETER_CONTROL);
    }

    public AbstractButton getPauseButton() {
        return (AbstractButton)this.getControl(PAUSE_CONTROL).getControlComponent();
    }

    public AbstractListenerControl getPauseControl() {
        return this.getControl(PAUSE_CONTROL);
    }

    public StandardProgressControl getProgressControl() {
        return (StandardProgressControl)this.getControl(PROGRESS_CONTROL);
    }

    public AbstractButton getReverseButton() {
        return (AbstractButton)this.getControl(REVERSE_CONTROL).getControlComponent();
    }

    public AbstractListenerControl getReverseControl() {
        return this.getControl(REVERSE_CONTROL);
    }

    public AbstractButton getStartButton() {
        return (AbstractButton)this.getControl(START_CONTROL).getControlComponent();
    }

    public AbstractListenerControl getStartControl() {
        return this.getControl(START_CONTROL);
    }

    public AbstractButton getStopButton() {
        return (AbstractButton)this.getControl(STOP_CONTROL).getControlComponent();
    }

    public AbstractListenerControl getStopControl() {
        return this.getControl(STOP_CONTROL);
    }

    protected void makeControls(Skin skin) {
        AbstractListenerControl abstractListenerControl = this.fastForwardControl = this.createFastForwardControl(skin);
        this.addControl(FF_CONTROL, this.fastForwardControl);
        abstractListenerControl = this.reverseControl = this.createReverseControl(skin);
        this.addControl(REVERSE_CONTROL, this.reverseControl);
        abstractListenerControl = this.startControl = this.createStartControl(skin);
        this.addControl(START_CONTROL, this.startControl);
        abstractListenerControl = this.stopControl = this.createStopControl(skin);
        this.addControl(STOP_CONTROL, this.stopControl);
        abstractListenerControl = this.pauseControl = this.createPauseControl(skin);
        this.addControl(PAUSE_CONTROL, this.pauseControl);
        abstractListenerControl = this.gainControl = this.createGainControl(skin);
        this.addControl(GAIN_CONTROL, this.gainControl);
        abstractListenerControl = this.gainMeterControl = this.createGainMeterControl(skin);
        this.addControl(GAINMETER_CONTROL, this.gainMeterControl);
        this.progressControl = this.createProgressControl(skin);
        abstractListenerControl = this.progressControl;
        this.addControl(PROGRESS_CONTROL, this.progressControl);
    }

    public void setControlComponentState(int n) {
        boolean bl = n == 600;
        this.getStartButton().setEnabled(!bl);
        this.getStopButton().setEnabled(bl);
        this.getPauseButton().setEnabled(bl);
        this.getReverseButton().setEnabled(bl);
        if (n != 600) {
            this.getProgressControl().setValue(this.getPlayer().getMediaTime().getNanoseconds());
        }
    }
}

