/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.media.codec.audio.ilbc;

import com.ibm.media.codec.audio.AudioCodec;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import net.java.sip.communicator.impl.media.codec.Constants;
import net.java.sip.communicator.impl.media.codec.audio.Utils;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_constants;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_encoder;

public class JavaEncoder
extends AudioCodec {
    private Format lastFormat = null;
    private ilbc_encoder enc = null;
    private int ILBC_NO_OF_BYTES = 0;

    public JavaEncoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("ilbc/rtp", 8000.0, 16, 1, 0, 1)};
        this.PLUGIN_NAME = "pcm to iLbc converter";
    }

    public void close() {
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, false, false);
        }
        return this.controls;
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("ilbc/rtp", 8000.0, 16, 1, 0, 1)};
        return this.supportedOutputFormats;
    }

    private void initConverter(AudioFormat audioFormat) {
        this.lastFormat = audioFormat;
    }

    public void open() throws ResourceUnavailableException {
        int n = Constants.ILBC_MODE;
        this.enc = new ilbc_encoder(n);
        if (n == 20) {
            this.ILBC_NO_OF_BYTES = ilbc_constants.NO_OF_BYTES_20MS;
        } else if (n == 30) {
            this.ILBC_NO_OF_BYTES = ilbc_constants.NO_OF_BYTES_30MS;
        }
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        Format format = buffer.getFormat();
        if (this.lastFormat != format) {
            this.initConverter((AudioFormat)format);
        }
        int n = buffer.getLength();
        int n2 = buffer.getOffset();
        byte[] byArray = (byte[])buffer.getData();
        if (n == 0) {
            return 4;
        }
        if (n < this.enc.ULP_inst.blockl * 2) {
            return 4;
        }
        short[] sArray = new short[this.ILBC_NO_OF_BYTES / 2];
        int n3 = this.ILBC_NO_OF_BYTES;
        byte[] byArray2 = this.validateByteArraySize(buffer2, n3);
        short[] sArray2 = Utils.byteToShortArray(byArray, n2, n, true);
        this.enc.encode(sArray, sArray2);
        Utils.shortArrToByteArr(sArray, byArray2, false);
        this.updateOutput(buffer2, this.outputFormat, n3, 0);
        buffer.setLength(n - this.enc.ULP_inst.blockl * 2);
        buffer.setOffset(n2 + this.enc.ULP_inst.blockl * 2);
        return 2;
    }
}

