/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.Header;
import org.jivesoftware.smackx.packet.HeadersExtension;
import org.jivesoftware.smackx.pubsub.ConfigurationEvent;
import org.jivesoftware.smackx.pubsub.ConfigureForm;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.EventElementType;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.ItemDeleteEvent;
import org.jivesoftware.smackx.pubsub.ItemPublishEvent;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.OptionsExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.RetractItem;
import org.jivesoftware.smackx.pubsub.SubscribeExtension;
import org.jivesoftware.smackx.pubsub.SubscribeForm;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.UnsubscribeExtension;
import org.jivesoftware.smackx.pubsub.listener.ItemDeleteListener;
import org.jivesoftware.smackx.pubsub.listener.ItemEventListener;
import org.jivesoftware.smackx.pubsub.listener.NodeConfigListener;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.packet.SyncPacketSend;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;

public abstract class Node {
    protected Connection con;
    protected String id;
    protected String to;
    protected ConcurrentHashMap<ItemEventListener, PacketListener> itemEventToListenerMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<ItemDeleteListener, PacketListener> itemDeleteToListenerMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<NodeConfigListener, PacketListener> configEventToListenerMap = new ConcurrentHashMap();

    Node(Connection connection, String nodeName) {
        this.con = connection;
        this.id = nodeName;
    }

    void setTo(String toAddress) {
        this.to = toAddress;
    }

    public String getId() {
        return this.id;
    }

    public ConfigureForm getNodeConfiguration() throws XMPPException {
        Packet reply = this.sendPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.CONFIGURE_OWNER, this.getId()), PubSubNamespace.OWNER);
        return NodeUtils.getFormFromPacket(reply, PubSubElementType.CONFIGURE_OWNER);
    }

    public void sendConfigurationForm(Form submitForm) throws XMPPException {
        PubSub packet = this.createPubsubPacket(IQ.Type.SET, new FormNode(FormNodeType.CONFIGURE_OWNER, this.getId(), submitForm), PubSubNamespace.OWNER);
        SyncPacketSend.getReply(this.con, (Packet)packet);
    }

    public DiscoverInfo discoverInfo() throws XMPPException {
        DiscoverInfo info = new DiscoverInfo();
        info.setTo(this.to);
        info.setNode(this.getId());
        return (DiscoverInfo)SyncPacketSend.getReply(this.con, (Packet)info);
    }

    public List<Subscription> getSubscriptions() throws XMPPException {
        PubSub reply = (PubSub)this.sendPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.SUBSCRIPTIONS, this.getId()));
        SubscriptionsExtension subElem = (SubscriptionsExtension)reply.getExtension(PubSubElementType.SUBSCRIPTIONS);
        return subElem.getSubscriptions();
    }

    public Subscription subscribe(String jid) throws XMPPException {
        PubSub reply = (PubSub)this.sendPubsubPacket(IQ.Type.SET, new SubscribeExtension(jid, this.getId()));
        return (Subscription)reply.getExtension(PubSubElementType.SUBSCRIPTION);
    }

    public Subscription subscribe(String jid, SubscribeForm subForm) throws XMPPException {
        PubSub request = this.createPubsubPacket(IQ.Type.SET, new SubscribeExtension(jid, this.getId()));
        request.addExtension(new FormNode(FormNodeType.OPTIONS, subForm));
        PubSub reply = (PubSub)PubSubManager.sendPubsubPacket(this.con, jid, IQ.Type.SET, request);
        return (Subscription)reply.getExtension(PubSubElementType.SUBSCRIPTION);
    }

    public void unsubscribe(String jid) throws XMPPException {
        this.unsubscribe(jid, null);
    }

    public void unsubscribe(String jid, String subscriptionId) throws XMPPException {
        this.sendPubsubPacket(IQ.Type.SET, new UnsubscribeExtension(jid, this.getId(), subscriptionId));
    }

    public SubscribeForm getSubscriptionOptions(String jid) throws XMPPException {
        return this.getSubscriptionOptions(jid, null);
    }

    public SubscribeForm getSubscriptionOptions(String jid, String subscriptionId) throws XMPPException {
        PubSub packet = (PubSub)this.sendPubsubPacket(IQ.Type.GET, new OptionsExtension(jid, this.getId(), subscriptionId));
        FormNode ext = (FormNode)packet.getExtension(PubSubElementType.OPTIONS);
        return new SubscribeForm(ext.getForm());
    }

    public void addItemEventListener(ItemEventListener listener) {
        ItemEventTranslator conListener = new ItemEventTranslator(listener);
        this.itemEventToListenerMap.put(listener, conListener);
        this.con.addPacketListener((PacketListener)conListener, (PacketFilter)new EventContentFilter(EventElementType.items.toString(), "item"));
    }

    public void removeItemEventListener(ItemEventListener listener) {
        PacketListener conListener = this.itemEventToListenerMap.remove(listener);
        if (conListener != null) {
            this.con.removePacketListener(conListener);
        }
    }

    public void addConfigurationListener(NodeConfigListener listener) {
        NodeConfigTranslator conListener = new NodeConfigTranslator(listener);
        this.configEventToListenerMap.put(listener, conListener);
        this.con.addPacketListener((PacketListener)conListener, (PacketFilter)new EventContentFilter(EventElementType.configuration.toString()));
    }

    public void removeConfigurationListener(NodeConfigListener listener) {
        PacketListener conListener = this.configEventToListenerMap.remove(listener);
        if (conListener != null) {
            this.con.removePacketListener(conListener);
        }
    }

    public void addItemDeleteListener(ItemDeleteListener listener) {
        ItemDeleteTranslator delListener = new ItemDeleteTranslator(listener);
        this.itemDeleteToListenerMap.put(listener, delListener);
        EventContentFilter deleteItem = new EventContentFilter(EventElementType.items.toString(), "retract");
        EventContentFilter purge = new EventContentFilter(EventElementType.purge.toString());
        this.con.addPacketListener((PacketListener)delListener, (PacketFilter)new OrFilter((PacketFilter)deleteItem, (PacketFilter)purge));
    }

    public void removeItemDeleteListener(ItemDeleteListener listener) {
        PacketListener conListener = this.itemDeleteToListenerMap.remove(listener);
        if (conListener != null) {
            this.con.removePacketListener(conListener);
        }
    }

    public String toString() {
        return super.toString() + " " + this.getClass().getName() + " id: " + this.id;
    }

    protected PubSub createPubsubPacket(IQ.Type type, PacketExtension ext) {
        return this.createPubsubPacket(type, ext, null);
    }

    protected PubSub createPubsubPacket(IQ.Type type, PacketExtension ext, PubSubNamespace ns) {
        return PubSubManager.createPubsubPacket(this.to, type, ext, ns);
    }

    protected Packet sendPubsubPacket(IQ.Type type, NodeExtension ext) throws XMPPException {
        return PubSubManager.sendPubsubPacket(this.con, this.to, type, ext);
    }

    protected Packet sendPubsubPacket(IQ.Type type, NodeExtension ext, PubSubNamespace ns) throws XMPPException {
        return PubSubManager.sendPubsubPacket(this.con, this.to, type, ext, ns);
    }

    private static List<String> getSubscriptionIds(Packet packet) {
        HeadersExtension headers = (HeadersExtension)packet.getExtension("headers", "http://jabber.org/protocol/shim");
        ArrayList<String> values = null;
        if (headers != null) {
            values = new ArrayList<String>(headers.getHeaders().size());
            for (Header header : headers.getHeaders()) {
                values.add(header.getValue());
            }
        }
        return values;
    }

    class EventContentFilter
    implements PacketFilter {
        private String firstElement;
        private String secondElement;

        EventContentFilter(String elementName) {
            this.firstElement = elementName;
        }

        EventContentFilter(String firstLevelEelement, String secondLevelElement) {
            this.firstElement = firstLevelEelement;
            this.secondElement = secondLevelElement;
        }

        public boolean accept(Packet packet) {
            if (!(packet instanceof Message)) {
                return false;
            }
            EventElement event = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            if (event == null) {
                return false;
            }
            NodeExtension embedEvent = event.getEvent();
            if (embedEvent == null) {
                return false;
            }
            if (embedEvent.getElementName().equals(this.firstElement)) {
                if (!embedEvent.getNode().equals(Node.this.getId())) {
                    return false;
                }
                if (this.secondElement == null) {
                    return true;
                }
                if (embedEvent instanceof EmbeddedPacketExtension) {
                    List<PacketExtension> secondLevelList = ((EmbeddedPacketExtension)((Object)embedEvent)).getExtensions();
                    if (secondLevelList.size() == 0) {
                        return true;
                    }
                    if (secondLevelList.size() > 0 && secondLevelList.get(0).getElementName().equals(this.secondElement)) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public class NodeConfigTranslator
    implements PacketListener {
        private NodeConfigListener listener;

        public NodeConfigTranslator(NodeConfigListener eventListener) {
            this.listener = eventListener;
        }

        public void processPacket(Packet packet) {
            EventElement event = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            ConfigurationEvent config = (ConfigurationEvent)event.getEvent();
            this.listener.handleNodeConfiguration(config);
        }
    }

    public class ItemDeleteTranslator
    implements PacketListener {
        private ItemDeleteListener listener;

        public ItemDeleteTranslator(ItemDeleteListener eventListener) {
            this.listener = eventListener;
        }

        public void processPacket(Packet packet) {
            EventElement event = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            List<PacketExtension> extList = event.getExtensions();
            if (extList.get(0).getElementName().equals(PubSubElementType.PURGE_EVENT.getElementName())) {
                this.listener.handlePurge();
            } else {
                ItemsExtension itemsElem = (ItemsExtension)event.getEvent();
                List<? extends PacketExtension> pubItems = itemsElem.getItems();
                Iterator it = pubItems.iterator();
                ArrayList<String> items = new ArrayList<String>(pubItems.size());
                while (it.hasNext()) {
                    RetractItem item = (RetractItem)it.next();
                    items.add(item.getId());
                }
                ItemDeleteEvent eventItems = new ItemDeleteEvent(itemsElem.getNode(), items, Node.getSubscriptionIds(packet));
                this.listener.handleDeletedItems(eventItems);
            }
        }
    }

    public class ItemEventTranslator
    implements PacketListener {
        private ItemEventListener listener;

        public ItemEventTranslator(ItemEventListener eventListener) {
            this.listener = eventListener;
        }

        public void processPacket(Packet packet) {
            EventElement event = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            ItemsExtension itemsElem = (ItemsExtension)event.getEvent();
            DelayInformation delay = (DelayInformation)packet.getExtension("delay", "urn:xmpp:delay");
            if (delay == null) {
                delay = (DelayInformation)packet.getExtension("x", "jabber:x:delay");
            }
            ItemPublishEvent<? extends PacketExtension> eventItems = new ItemPublishEvent<PacketExtension>(itemsElem.getNode(), itemsElem.getItems(), Node.getSubscriptionIds(packet), delay == null ? null : delay.getStamp());
            this.listener.handlePublishedItems(eventItems);
        }
    }
}

