/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ServiceObserver<T>
implements ServiceListener {
    private final Class<T> clazz;
    private BundleContext context;
    private final List<T> services = new ArrayList<T>();

    public ServiceObserver(Class<T> clazz) {
        this.clazz = clazz;
    }

    public List<T> getServices() {
        return Collections.unmodifiableList(this.services);
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        Object service = this.context.getService(serviceEvent.getServiceReference());
        if (!this.clazz.isInstance(service)) {
            return;
        }
        int eventType = serviceEvent.getType();
        if (eventType == 1) {
            this.services.add(service);
        } else if (eventType == 4) {
            this.services.remove(service);
        }
    }

    public void start(BundleContext ctx) {
        this.context = ctx;
        ctx.addServiceListener((ServiceListener)this);
        Collection<ServiceReference<T>> refs = ServiceUtils.getServiceReferences(ctx, this.clazz);
        for (ServiceReference<T> ref : refs) {
            this.services.add(ctx.getService(ref));
        }
    }

    public void stop(BundleContext ctx) {
        ctx.removeServiceListener((ServiceListener)this);
        this.services.clear();
        this.context = null;
    }
}

