/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPushBufferCaptureDevice;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPushBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;

public class AudioSilenceCaptureDevice
extends AbstractPushBufferCaptureDevice {
    private static final boolean CLOCK_ONLY = true;
    private static final long CLOCK_TICK_INTERVAL = 20L;
    private static final Format[] SUPPORTED_FORMATS = new Format[]{new AudioFormat("LINEAR", 48000.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};

    protected AudioSilenceStream createStream(int streamIndex, FormatControl formatControl) {
        return new AudioSilenceStream(this, formatControl);
    }

    protected Format[] getSupportedFormats(int streamIndex) {
        return (Format[])SUPPORTED_FORMATS.clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AudioSilenceStream
    extends AbstractPushBufferStream<AudioSilenceCaptureDevice>
    implements Runnable {
        private boolean started;
        private Thread thread;

        public AudioSilenceStream(AudioSilenceCaptureDevice dataSource, FormatControl formatControl) {
            super((PushBufferDataSource)dataSource, formatControl);
        }

        public void read(Buffer buffer) throws IOException {
            buffer.setLength(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                AbstractAudioRenderer.useAudioThreadPriority();
                tickTime = System.currentTimeMillis();
                while (true) lbl-1000:
                // 4 sources

                {
                    v0 = tick = (sleepInterval = tickTime - System.currentTimeMillis()) <= 0L;
                    if (tick) {
                        tickTime += 20L;
                    } else {
                        try {
                            Thread.sleep(sleepInterval);
                        }
                        catch (InterruptedException var6_5) {
                            // empty catch block
                        }
                    }
                    var6_4 = this;
                    synchronized (var6_4) {
                        if (this.thread != Thread.currentThread() || !this.started) {
                            ** break;
                        }
                    }
                    if (!tick || (transferHandler = this.transferHandler) == null) continue;
                    try {
                        transferHandler.transferData((PushBufferStream)this);
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) ** break;
                        continue;
                        throw (ThreadDeath)t;
                    }
                    break;
                }
                ** GOTO lbl-1000
lbl31:
                // 1 sources

                var9_8 = null;
                var10_10 = this;
            }
            catch (Throwable var8_14) {
                var9_9 = null;
                var10_11 = this;
                synchronized (var10_11) {
                    if (this.thread == Thread.currentThread()) {
                        this.thread = null;
                        this.started = false;
                        this.notifyAll();
                    }
                }
                throw var8_14;
            }
            synchronized (var10_10) {
                if (this.thread == Thread.currentThread()) {
                    this.thread = null;
                    this.started = false;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void start() throws IOException {
            block4: {
                if (this.thread == null) {
                    String className = this.getClass().getName();
                    this.thread = new Thread((Runnable)this, className);
                    this.thread.setDaemon(true);
                    boolean started = false;
                    try {
                        this.thread.start();
                        started = true;
                        Object var4_3 = null;
                        this.started = started;
                        if (started) break block4;
                        this.thread = null;
                        this.notifyAll();
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        this.started = started;
                        if (!started) {
                            this.thread = null;
                            this.notifyAll();
                            throw new IOException("Failed to start " + className);
                        }
                        throw throwable;
                    }
                    throw new IOException("Failed to start " + className);
                }
            }
        }

        public synchronized void stop() throws IOException {
            this.started = false;
            this.notifyAll();
            boolean interrupted = false;
            while (this.thread != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

