/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.theora_java;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.media.util.ImageToBuffer;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.theora_java.jna.OggLibrary;
import net.sf.theora_java.jna.TheoraLibrary;
import net.sf.theora_java.jna.VorbisLibrary;
import net.sf.theora_java.jna.XiphLibrary;
import net.sf.theora_java.jna.utils.YUVConverter;

public class NativeOggParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private final TheoraLibrary THEORA;
    private final OggLibrary OGG;
    private final VorbisLibrary VORBIS;
    private static final boolean ENABLE_VIDEO = true;
    private static final boolean ENABLE_AUDIO = true;
    private final OggLibrary.ogg_sync_state oy = new OggLibrary.ogg_sync_state();
    private final OggLibrary.ogg_page og = new OggLibrary.ogg_page();
    private OggLibrary.ogg_stream_state vo = new OggLibrary.ogg_stream_state();
    private OggLibrary.ogg_stream_state to = new OggLibrary.ogg_stream_state();
    private final TheoraLibrary.theora_info ti = new TheoraLibrary.theora_info();
    private final TheoraLibrary.theora_comment tc = new TheoraLibrary.theora_comment();
    private final TheoraLibrary.theora_state td = new TheoraLibrary.theora_state();
    private final VorbisLibrary.vorbis_info vi = new VorbisLibrary.vorbis_info();
    private final VorbisLibrary.vorbis_dsp_state vd = new VorbisLibrary.vorbis_dsp_state();
    private final VorbisLibrary.vorbis_block vb = new VorbisLibrary.vorbis_block();
    private VorbisLibrary.vorbis_comment vc = new VorbisLibrary.vorbis_comment();
    private int theora_p = 0;
    private int vorbis_p = 0;
    private int stateflag = 0;
    private int videobuf_ready = 0;
    private long videobuf_granulepos = -1L;
    private double videobuf_time = 0.0;
    private int audiobuf_fill = 0;
    private int audiobuf_ready = 0;
    private short[] audiobuf;
    private int audiofd_fragsize;
    private final XiphLibrary.ogg_packet op = new XiphLibrary.ogg_packet();
    private final boolean USE_DATASOURCE_URL_ONLY = false;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("video.ogg"), new ContentDescriptor("audio.ogg"), new ContentDescriptor("application.ogg"), new ContentDescriptor("application.x_ogg")};
    private static final Object OGG_SYNC_OBJ = new Boolean(true);
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;
    private FileInputStream infile;
    private PullSourceStream instream;
    private boolean eomAudio;
    private boolean eomVideo;
    private int videoFrameNo = -1;

    public static AudioFormat convertCodecAudioFormat(VorbisLibrary.vorbis_info vorbis_info2) {
        return new AudioFormat("LINEAR", vorbis_info2.rate.floatValue(), 16, vorbis_info2.channels, 0, 1);
    }

    public static VideoFormat convertCodecPixelFormat(TheoraLibrary.theora_info theora_info2) {
        Dimension dimension = new Dimension(theora_info2.width, theora_info2.height);
        int n = theora_info2.width * theora_info2.height;
        Class<int[]> clazz = int[].class;
        float f = (float)theora_info2.fps_numerator / (float)theora_info2.fps_denominator;
        int n2 = 0xFF0000;
        int n3 = 65280;
        int n4 = 255;
        return new RGBFormat(dimension, n, clazz, f, 32, n2, n3, n4);
    }

    static void report_colorspace(TheoraLibrary.theora_info theora_info2) {
        switch (theora_info2.colorspace) {
            case 0: {
                break;
            }
            case 1: {
                logger.info("  encoder specified ITU Rec 470M (NTSC) color.");
                break;
            }
            case 2: {
                logger.info("  encoder specified ITU Rec 470BG (PAL) color.");
                break;
            }
            default: {
                logger.warning("warning: encoder specified unknown colorspace (" + theora_info2.colorspace + ")");
            }
        }
    }

    private static final double secondsToNanos(double d) {
        return d * 1.0E9;
    }

    public NativeOggParser() {
        try {
            this.THEORA = TheoraLibrary.INSTANCE;
            this.OGG = OggLibrary.INSTANCE;
            this.VORBIS = VorbisLibrary.INSTANCE;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Unable to initialize ffmpeg libraries: " + throwable);
            throw new RuntimeException(throwable);
        }
    }

    private int buffer_data(FileInputStream fileInputStream, OggLibrary.ogg_sync_state ogg_sync_state2) throws IOException {
        Pointer pointer = this.OGG.ogg_sync_buffer(ogg_sync_state2, new NativeLong(4096L));
        byte[] byArray = new byte[4096];
        int n = fileInputStream.read(byArray, 0, 4096);
        if (n < 0) {
            return n;
        }
        pointer.write(0L, byArray, 0, n);
        this.OGG.ogg_sync_wrote(ogg_sync_state2, new NativeLong((long)n));
        return n;
    }

    private int buffer_data(OggLibrary.ogg_sync_state ogg_sync_state2) throws IOException {
        return this.buffer_data(this.instream, ogg_sync_state2);
    }

    private int buffer_data(PullSourceStream pullSourceStream, OggLibrary.ogg_sync_state ogg_sync_state2) throws IOException {
        Pointer pointer = this.OGG.ogg_sync_buffer(ogg_sync_state2, new NativeLong(4096L));
        byte[] byArray = new byte[4096];
        int n = pullSourceStream.read(byArray, 0, 4096);
        if (n < 0) {
            return n;
        }
        pointer.write(0L, byArray, 0, n);
        this.OGG.ogg_sync_wrote(ogg_sync_state2, new NativeLong((long)n));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            if (this.tracks != null) {
                for (int i = 0; i < this.tracks.length; ++i) {
                    if (this.tracks[i] == null) continue;
                    this.tracks[i].deallocate();
                    this.tracks[i] = null;
                }
                this.tracks = null;
            }
            if (this.vorbis_p != 0) {
                this.OGG.ogg_stream_clear(this.vo);
                this.VORBIS.vorbis_block_clear(this.vb);
                this.VORBIS.vorbis_dsp_clear(this.vd);
                this.VORBIS.vorbis_comment_clear(this.vc);
                this.VORBIS.vorbis_info_clear(this.vi);
            }
            if (this.theora_p != 0) {
                this.OGG.ogg_stream_clear(this.to);
                this.THEORA.theora_clear(this.td);
                this.THEORA.theora_comment_clear(this.tc);
                this.THEORA.theora_info_clear(this.ti);
            }
            this.OGG.ogg_sync_clear(this.oy);
            try {
                if (this.infile != null) {
                    this.infile.close();
                }
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
            }
        }
        super.close();
    }

    int dump_comments(TheoraLibrary.theora_comment theora_comment2) {
        logger.info("Encoded by " + theora_comment2.vendor.getString(0L));
        if (theora_comment2.comments > 0) {
            logger.info("theora comment header:");
            for (int i = 0; i < theora_comment2.comments; ++i) {
                Pointer[] pointerArray = theora_comment2.user_comments.getPointerArray(0L, theora_comment2.comments);
                int[] nArray = theora_comment2.comment_lengths.getIntArray(0L, theora_comment2.comments);
                if (pointerArray[i] == null) continue;
                int n = nArray[i];
                String string = new String(pointerArray[i].getByteArray(0L, n));
                logger.info("\t" + string);
            }
        }
        return 0;
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public boolean isPositionable() {
        return false;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextAudioBuffer() throws IOException {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            int n;
            while (this.vorbis_p != 0 && this.audiobuf_ready == 0) {
                PointerByReference pointerByReference = new PointerByReference();
                n = this.VORBIS.vorbis_synthesis_pcmout(this.vd, pointerByReference);
                if (n > 0) {
                    int n2;
                    int n3;
                    Pointer pointer = pointerByReference.getValue();
                    Pointer[] pointerArray = pointer.getPointerArray(0L, this.vi.channels);
                    float[][] fArrayArray = new float[pointerArray.length][];
                    for (n3 = 0; n3 < pointerArray.length; ++n3) {
                        fArrayArray[n3] = pointerArray[n3].getFloatArray(0L, n);
                    }
                    n3 = this.audiobuf_fill / 2;
                    int n4 = (this.audiofd_fragsize - this.audiobuf_fill) / 2 / this.vi.channels;
                    for (n2 = 0; n2 < n && n2 < n4; ++n2) {
                        for (int i = 0; i < this.vi.channels; ++i) {
                            int n5 = Math.round(fArrayArray[i][n2] * 32767.0f);
                            if (n5 > Short.MAX_VALUE) {
                                n5 = Short.MAX_VALUE;
                            }
                            if (n5 < Short.MIN_VALUE) {
                                n5 = Short.MIN_VALUE;
                            }
                            this.audiobuf[n3++] = (short)n5;
                        }
                    }
                    this.VORBIS.vorbis_synthesis_read(this.vd, n2);
                    this.audiobuf_fill += n2 * this.vi.channels * 2;
                    if (this.audiobuf_fill != this.audiofd_fragsize) continue;
                    this.audiobuf_ready = 1;
                    continue;
                }
                if (this.OGG.ogg_stream_packetout(this.vo, this.op) <= 0) break;
                if (this.VORBIS.vorbis_synthesis(this.vb, this.op) != 0) continue;
                this.VORBIS.vorbis_synthesis_blockin(this.vd, this.vb);
            }
            if (this.audiobuf_ready == 0) {
                n = this.buffer_data(this.oy);
                if (n < 0) {
                    this.eomAudio = true;
                }
                while (this.OGG.ogg_sync_pageout(this.oy, this.og) > 0) {
                    this.queue_page(this.og);
                }
            }
            if (this.vorbis_p == 0 || this.audiobuf_ready != 0) {
                this.stateflag = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextVideoBuffer() throws IOException {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            int n;
            while (this.theora_p != 0 && this.videobuf_ready == 0 && this.OGG.ogg_stream_packetout(this.to, this.op) > 0) {
                ++this.videoFrameNo;
                n = this.THEORA.theora_decode_packetin(this.td, this.op);
                if (n < 0) {
                    throw new IOException("theora_decode_packetin failed: " + n);
                }
                this.videobuf_granulepos = this.td.granulepos;
                this.videobuf_time = this.THEORA.theora_granule_time(this.td, this.videobuf_granulepos);
                if (this.videobuf_time == 0.0) {
                    this.videobuf_time = (double)this.videoFrameNo * (double)this.ti.fps_denominator / (double)this.ti.fps_numerator;
                }
                this.videobuf_ready = 1;
            }
            if (this.videobuf_ready == 0) {
                n = this.buffer_data(this.oy);
                if (n < 0) {
                    this.eomVideo = true;
                }
                while (this.OGG.ogg_sync_pageout(this.oy, this.og) > 0) {
                    this.queue_page(this.og);
                }
            }
            if (this.theora_p == 0 || this.videobuf_ready != 0) {
                this.stateflag = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceUnavailableException {
        Object object = OGG_SYNC_OBJ;
        synchronized (object) {
            try {
                int n;
                this.source.connect();
                this.source.start();
                this.instream = this.source.getStreams()[0];
                this.OGG.ogg_sync_init(this.oy);
                this.VORBIS.vorbis_info_init(this.vi);
                this.VORBIS.vorbis_comment_init(this.vc);
                this.THEORA.theora_comment_init(this.tc);
                this.THEORA.theora_info_init(this.ti);
                block10: while (this.stateflag == 0 && (n = this.buffer_data(this.oy)) > 0) {
                    while (this.OGG.ogg_sync_pageout(this.oy, this.og) > 0) {
                        OggLibrary.ogg_stream_state ogg_stream_state2 = new OggLibrary.ogg_stream_state();
                        if (this.OGG.ogg_page_bos(this.og) == 0) {
                            this.queue_page(this.og);
                            this.stateflag = 1;
                            continue block10;
                        }
                        this.OGG.ogg_stream_init(ogg_stream_state2, this.OGG.ogg_page_serialno(this.og));
                        this.OGG.ogg_stream_pagein(ogg_stream_state2, this.og);
                        this.OGG.ogg_stream_packetout(ogg_stream_state2, this.op);
                        if (this.theora_p == 0 && this.THEORA.theora_decode_header(this.ti, this.tc, this.op) >= 0) {
                            this.to = ogg_stream_state2;
                            this.theora_p = 1;
                            continue;
                        }
                        if (this.vorbis_p == 0 && this.VORBIS.vorbis_synthesis_headerin(this.vi, this.vc, this.op) >= 0) {
                            this.vo = ogg_stream_state2;
                            this.vorbis_p = 1;
                            continue;
                        }
                        this.OGG.ogg_stream_clear(ogg_stream_state2);
                    }
                }
                while (this.theora_p != 0 && this.theora_p < 3 || this.vorbis_p != 0 && this.vorbis_p < 3) {
                    while (this.theora_p != 0 && this.theora_p < 3 && (n = this.OGG.ogg_stream_packetout(this.to, this.op)) != 0) {
                        if (n < 0) {
                            throw new ResourceUnavailableException("Error parsing Theora stream headers; corrupt stream?");
                        }
                        if (this.THEORA.theora_decode_header(this.ti, this.tc, this.op) != 0) {
                            throw new ResourceUnavailableException("Error parsing Theora stream headers; corrupt stream?");
                        }
                        ++this.theora_p;
                        if (this.theora_p != 3) continue;
                    }
                    while (this.vorbis_p != 0 && this.vorbis_p < 3 && (n = this.OGG.ogg_stream_packetout(this.vo, this.op)) != 0) {
                        if (n < 0) {
                            throw new ResourceUnavailableException("Error parsing Vorbis stream headers; corrupt stream?");
                        }
                        if (this.VORBIS.vorbis_synthesis_headerin(this.vi, this.vc, this.op) != 0) {
                            throw new ResourceUnavailableException("Error parsing Vorbis stream headers; corrupt stream?");
                        }
                        ++this.vorbis_p;
                        if (this.vorbis_p != 3) continue;
                    }
                    if (this.OGG.ogg_sync_pageout(this.oy, this.og) > 0) {
                        this.queue_page(this.og);
                        continue;
                    }
                    int n2 = this.buffer_data(this.oy);
                    if (n2 > 0) continue;
                    throw new ResourceUnavailableException("End of file while searching for codec headers.");
                }
                if (this.theora_p != 0) {
                    this.THEORA.theora_decode_init(this.td, this.ti);
                    double d = (double)this.ti.fps_numerator / (double)this.ti.fps_denominator;
                    logger.info("Ogg logical stream " + Integer.toHexString(this.to.serialno.intValue()) + " is Theora " + this.ti.width + "x" + this.ti.height + " " + d + " fps");
                    switch (this.ti.pixelformat) {
                        case 0: {
                            logger.info(" 4:2:0 video");
                            break;
                        }
                        case 2: {
                            logger.info(" 4:2:2 video");
                            break;
                        }
                        case 3: {
                            logger.info(" 4:4:4 video");
                            break;
                        }
                        default: {
                            logger.info(" video\n  (UNKNOWN Chroma sampling!)");
                        }
                    }
                    if (this.ti.width != this.ti.frame_width || this.ti.height != this.ti.frame_height) {
                        logger.warning("  Frame content is " + this.ti.frame_width + "x" + this.ti.frame_height + " with offset (" + this.ti.offset_x + "," + this.ti.offset_y + ").");
                    }
                    NativeOggParser.report_colorspace(this.ti);
                    this.dump_comments(this.tc);
                } else {
                    this.THEORA.theora_info_clear(this.ti);
                    this.THEORA.theora_comment_clear(this.tc);
                }
                if (this.vorbis_p != 0) {
                    this.VORBIS.vorbis_synthesis_init(this.vd, this.vi);
                    this.VORBIS.vorbis_block_init(this.vd, this.vb);
                    logger.info("Ogg logical stream " + Integer.toHexString(this.vo.serialno.intValue()) + " is Vorbis " + this.vi.channels + " channel " + this.vi.rate.intValue() + " Hz audio.");
                } else {
                    this.VORBIS.vorbis_info_clear(this.vi);
                    this.VORBIS.vorbis_comment_clear(this.vc);
                }
                this.stateflag = 0;
                VideoTrack videoTrack = null;
                AudioTrack audioTrack = null;
                if (this.theora_p != 0) {
                    videoTrack = new VideoTrack();
                }
                if (this.vorbis_p != 0) {
                    audioTrack = new AudioTrack();
                }
                if (audioTrack == null && videoTrack == null) {
                    throw new ResourceUnavailableException("No audio or video track found");
                }
                this.tracks = audioTrack != null && videoTrack != null ? new PullSourceStreamTrack[]{videoTrack, audioTrack} : (audioTrack != null ? new PullSourceStreamTrack[]{audioTrack} : new PullSourceStreamTrack[]{videoTrack});
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                throw new ResourceUnavailableException("" + iOException);
            }
        }
        super.open();
    }

    int queue_page(OggLibrary.ogg_page ogg_page2) {
        if (this.theora_p != 0) {
            this.OGG.ogg_stream_pagein(this.to, this.og);
        }
        if (this.vorbis_p != 0) {
            this.OGG.ogg_stream_pagein(this.vo, this.og);
        }
        return 0;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        String string = dataSource.getLocator().getProtocol();
        if (!(dataSource instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)dataSource;
    }

    public void start() throws IOException {
    }

    static /* synthetic */ short[] access$202(NativeOggParser nativeOggParser, short[] sArray) {
        nativeOggParser.audiobuf = sArray;
        return sArray;
    }

    private class VideoTrack
    extends PullSourceStreamTrack {
        private final VideoFormat format;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VideoTrack() throws ResourceUnavailableException {
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                this.format = NativeOggParser.convertCodecPixelFormat(NativeOggParser.this.ti);
            }
        }

        public void deallocate() {
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }

        public Format getFormat() {
            return this.format;
        }

        public Time mapFrameToTime(int n) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time time) {
            return Integer.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                try {
                    NativeOggParser.this.nextVideoBuffer();
                }
                catch (IOException iOException) {
                    buffer.setLength(0);
                    buffer.setDiscard(true);
                    throw new RuntimeException(iOException);
                }
                if (NativeOggParser.this.stateflag != 0 && NativeOggParser.this.videobuf_ready != 0) {
                    TheoraLibrary.yuv_buffer yuv_buffer2 = new TheoraLibrary.yuv_buffer();
                    NativeOggParser.this.THEORA.theora_decode_YUVout(NativeOggParser.this.td, yuv_buffer2);
                    BufferedImage bufferedImage = YUVConverter.toBufferedImage((TheoraLibrary.yuv_buffer)yuv_buffer2, (TheoraLibrary.theora_info)NativeOggParser.this.ti);
                    Buffer buffer2 = ImageToBuffer.createBuffer(bufferedImage, this.format.getFrameRate());
                    buffer.setData(buffer2.getData());
                    buffer.setLength(buffer2.getLength());
                    buffer.setOffset(buffer2.getOffset());
                    buffer.setEOM(false);
                    buffer.setDiscard(false);
                    buffer.setTimeStamp((long)NativeOggParser.secondsToNanos(NativeOggParser.this.videobuf_time));
                    NativeOggParser.this.videobuf_ready = 0;
                } else {
                    buffer.setEOM(NativeOggParser.this.eomVideo);
                    buffer.setLength(0);
                    if (!NativeOggParser.this.eomVideo) {
                        buffer.setDiscard(true);
                    }
                }
            }
        }
    }

    private abstract class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStreamTrack() {
        }

        public abstract void deallocate();
    }

    private class AudioTrack
    extends PullSourceStreamTrack {
        private final AudioFormat format;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AudioTrack() throws ResourceUnavailableException {
            NativeOggParser.this.audiofd_fragsize = 10000;
            NativeOggParser.access$202(NativeOggParser.this, new short[NativeOggParser.this.audiofd_fragsize / 2]);
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                this.format = NativeOggParser.convertCodecAudioFormat(NativeOggParser.this.vi);
            }
        }

        public void deallocate() {
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }

        public Format getFormat() {
            return this.format;
        }

        public Time mapFrameToTime(int n) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time time) {
            return Integer.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            Object object = OGG_SYNC_OBJ;
            synchronized (object) {
                try {
                    NativeOggParser.this.nextAudioBuffer();
                }
                catch (IOException iOException) {
                    buffer.setLength(0);
                    buffer.setDiscard(true);
                    throw new RuntimeException(iOException);
                }
                if (NativeOggParser.this.stateflag == 0) {
                    buffer.setEOM(NativeOggParser.this.eomAudio);
                    buffer.setLength(0);
                    if (!NativeOggParser.this.eomAudio) {
                        buffer.setDiscard(true);
                    }
                    return;
                }
                if (NativeOggParser.this.audiobuf_ready == 0) {
                    buffer.setEOM(NativeOggParser.this.eomAudio);
                    buffer.setLength(0);
                    if (!NativeOggParser.this.eomAudio) {
                        buffer.setDiscard(true);
                    }
                    return;
                }
                byte[] byArray = new byte[NativeOggParser.this.audiobuf.length * 2];
                for (int i = 0; i < NativeOggParser.this.audiobuf.length; ++i) {
                    byArray[i * 2] = (byte)(NativeOggParser.this.audiobuf[i] & 0xFF);
                    byArray[i * 2 + 1] = (byte)(NativeOggParser.this.audiobuf[i] >> 8 & 0xFF);
                }
                buffer.setData(byArray);
                buffer.setLength(byArray.length);
                buffer.setOffset(0);
                buffer.setEOM(false);
                buffer.setDiscard(false);
                buffer.setTimeStamp(System.currentTimeMillis());
                NativeOggParser.this.audiobuf_fill = 0;
                NativeOggParser.this.audiobuf_ready = 0;
            }
        }
    }
}

