/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.SourceCloneable;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.media.PullSourceStreamInputStream;
import net.sf.fmj.media.renderer.audio.JavaSoundUtils;
import net.sf.fmj.utility.LoggerSingleton;

public class JavaSoundParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("audio.x_wav"), new ContentDescriptor("audio.basic"), new ContentDescriptor("audio.x_aiff"), new ContentDescriptor("audio.mpeg"), new ContentDescriptor("audio.ogg"), new ContentDescriptor("application.ogg")};
    private PullDataSource sourceForFormat;
    private PullDataSource sourceForReadFrame;
    private PullSourceStreamTrack[] tracks;
    private static final boolean OPEN_IN_SET_SOURCE = true;

    private static InputStream markSupportedInputStream(InputStream inputStream) {
        if (inputStream.markSupported()) {
            return inputStream;
        }
        return new BufferedInputStream(inputStream);
    }

    private static final double nanosToSeconds(double d) {
        return d / 1.0E9;
    }

    private static final double secondsToNanos(double d) {
        return d * 1.0E9;
    }

    private void doOpen() throws IOException, UnsupportedAudioFileException {
        this.sourceForReadFrame = (PullDataSource)((SourceCloneable)((Object)this.sourceForFormat)).createClone();
        if (this.sourceForReadFrame == null) {
            throw new IOException("Could not create clone");
        }
        this.sourceForReadFrame.start();
        this.sourceForFormat.start();
        PullSourceStream[] pullSourceStreamArray = this.sourceForFormat.getStreams();
        PullSourceStream[] pullSourceStreamArray2 = this.sourceForReadFrame.getStreams();
        this.tracks = new PullSourceStreamTrack[pullSourceStreamArray.length];
        for (int i = 0; i < pullSourceStreamArray.length; ++i) {
            this.tracks[i] = new PullSourceStreamTrack(pullSourceStreamArray[i], pullSourceStreamArray2[i]);
        }
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public boolean isPositionable() {
        return true;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    public void open() throws ResourceUnavailableException {
    }

    public Time setPosition(Time time, int n) {
        int n2;
        for (n2 = 0; n2 < this.tracks.length; ++n2) {
            if (this.tracks[n2].canSkipNanos()) continue;
            return super.setPosition(time, n);
        }
        if (time.getNanoseconds() == 0L) {
            n2 = 1;
            for (int i = 0; i < this.tracks.length; ++i) {
                if (this.tracks[i].getTotalBytesRead() == 0L) continue;
                n2 = 0;
                break;
            }
            if (n2 != 0) {
                return time;
            }
        }
        try {
            logger.fine("JavaSoundParser: cloning, reconnecting, and restarting source");
            this.sourceForReadFrame = (PullDataSource)((SourceCloneable)((Object)this.sourceForFormat)).createClone();
            if (this.sourceForReadFrame == null) {
                throw new RuntimeException("Could not create clone");
            }
            this.sourceForReadFrame.start();
            for (n2 = 0; n2 < this.tracks.length; ++n2) {
                this.tracks[n2].setPssForReadFrame(this.sourceForReadFrame.getStreams()[n2]);
                if (time.getNanoseconds() <= 0L) continue;
                this.tracks[n2].skipNanos(time.getNanoseconds());
            }
            return time;
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
            throw new RuntimeException(iOException);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            logger.log(Level.WARNING, "" + unsupportedAudioFileException, unsupportedAudioFileException);
            throw new RuntimeException(unsupportedAudioFileException);
        }
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (!(dataSource instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        if (!(dataSource instanceof SourceCloneable)) {
            throw new IncompatibleSourceException();
        }
        this.sourceForFormat = (PullDataSource)dataSource;
        try {
            this.doOpen();
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            logger.log(Level.INFO, "" + unsupportedAudioFileException);
            throw new IncompatibleSourceException("" + unsupportedAudioFileException);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
            throw iOException;
        }
    }

    public void start() throws IOException {
    }

    private class PullSourceStreamTrack
    extends AbstractTrack {
        private final AudioFormat format;
        private final javax.sound.sampled.AudioFormat javaSoundInputFormat;
        private final long frameLength;
        private PullSourceStream pssForReadFrame;
        private PullSourceStreamInputStream pssisForReadFrame;
        private AudioInputStream aisForReadFrame;
        private long totalBytesRead = 0L;

        public PullSourceStreamTrack(PullSourceStream pullSourceStream, PullSourceStream pullSourceStream2) throws UnsupportedAudioFileException, IOException {
            PullSourceStreamInputStream pullSourceStreamInputStream = new PullSourceStreamInputStream(pullSourceStream);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(JavaSoundParser.markSupportedInputStream(pullSourceStreamInputStream));
            this.javaSoundInputFormat = audioInputStream.getFormat();
            this.frameLength = audioInputStream.getFrameLength();
            this.format = JavaSoundUtils.convertFormat(this.javaSoundInputFormat);
            logger.fine("JavaSoundParser: java sound format: " + this.javaSoundInputFormat);
            logger.fine("JavaSoundParser: jmf format: " + this.format);
            logger.fine("JavaSoundParser: Frame length=" + this.frameLength);
            audioInputStream.close();
            pullSourceStreamInputStream.close();
            this.setPssForReadFrame(pullSourceStream2);
        }

        private long bytesToNanos(long l) {
            if (this.javaSoundInputFormat.getFrameSize() > 0 && this.javaSoundInputFormat.getFrameRate() > 0.0f) {
                long l2 = l / (long)this.javaSoundInputFormat.getFrameSize();
                double d = (float)l2 / this.javaSoundInputFormat.getFrameRate();
                double d2 = JavaSoundParser.secondsToNanos(d);
                return (long)d2;
            }
            return -1L;
        }

        public boolean canSkipNanos() {
            return this.javaSoundInputFormat.getFrameSize() > 0 && this.javaSoundInputFormat.getFrameRate() > 0.0f;
        }

        public Time getDuration() {
            long l = this.frameLength;
            if (l < 0L) {
                logger.fine("PullSourceStreamTrack: returning Duration.DURATION_UNKNOWN (1)");
                return Duration.DURATION_UNKNOWN;
            }
            double d = (float)l / this.javaSoundInputFormat.getFrameRate();
            if (d < 0.0) {
                logger.fine("PullSourceStreamTrack: returning Duration.DURATION_UNKNOWN (2)");
                return Duration.DURATION_UNKNOWN;
            }
            double d2 = JavaSoundParser.secondsToNanos(d);
            logger.fine("PullSourceStreamTrack: returning " + (long)d2);
            return new Time((long)d2);
        }

        public Format getFormat() {
            return this.format;
        }

        public long getTotalBytesRead() {
            return this.totalBytesRead;
        }

        public Time mapFrameToTime(int n) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time time) {
            return Integer.MAX_VALUE;
        }

        private long nanosToBytes(long l) {
            if (this.javaSoundInputFormat.getFrameSize() > 0 && this.javaSoundInputFormat.getFrameRate() > 0.0f) {
                double d = JavaSoundParser.nanosToSeconds(l);
                double d2 = d * (double)this.javaSoundInputFormat.getFrameRate();
                double d3 = d2 * (double)this.javaSoundInputFormat.getFrameSize();
                return (long)d3;
            }
            return -1L;
        }

        public void readFrame(Buffer buffer) {
            if (buffer.getData() == null) {
                buffer.setData(new byte[10000]);
            }
            byte[] byArray = (byte[])buffer.getData();
            try {
                int n = this.aisForReadFrame.read(byArray, 0, byArray.length);
                if (n < 0) {
                    buffer.setEOM(true);
                    buffer.setLength(0);
                    return;
                }
                if (this.javaSoundInputFormat.getFrameSize() > 0 && this.javaSoundInputFormat.getFrameRate() > 0.0f) {
                    buffer.setTimeStamp(this.bytesToNanos(this.totalBytesRead));
                    buffer.setDuration(this.bytesToNanos(n));
                }
                this.totalBytesRead += (long)n;
                buffer.setLength(n);
                buffer.setOffset(0);
            }
            catch (IOException iOException) {
                buffer.setEOM(true);
                buffer.setDiscard(true);
                buffer.setLength(0);
                logger.log(Level.WARNING, "" + iOException, iOException);
            }
        }

        public void setPssForReadFrame(PullSourceStream pullSourceStream) throws UnsupportedAudioFileException, IOException {
            this.pssForReadFrame = pullSourceStream;
            this.pssisForReadFrame = new PullSourceStreamInputStream(pullSourceStream);
            this.aisForReadFrame = AudioSystem.getAudioInputStream(JavaSoundParser.markSupportedInputStream(this.pssisForReadFrame));
            this.totalBytesRead = 0L;
        }

        public long skipNanos(long l) throws IOException {
            long l2 = this.nanosToBytes(l);
            if (l2 <= 0L) {
                logger.fine("JavaSoundParser: skipping nanos: 0");
                return 0L;
            }
            long l3 = this.aisForReadFrame.skip(l2);
            this.totalBytesRead += l3;
            if (l3 == l2) {
                logger.fine("JavaSoundParser: skipping nanos: " + l);
                return l;
            }
            long l4 = this.bytesToNanos(l3);
            logger.fine("JavaSoundParser: skipping nanos: " + l4);
            return l4;
        }
    }
}

